package com.bxm.report.web.controller;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.order.model.dto.BusinessOrderDto;
import com.bxm.datapark.facade.order.model.vo.BusinessOrderVo;
import com.bxm.report.facade.datapark.DataparkBusinessOrderPullerIntegration;
import com.bxm.util.dto.ResultModel;

@RestController
@RequestMapping("/bizOrderReport")
public class BusinessOrderReportController {
    
    @Autowired
    private DataparkBusinessOrderPullerIntegration businessOrderPullerIntegration;
    
    @RequestMapping(value = "/order", method = RequestMethod.GET)
    public ResultModel<Page<BusinessOrderVo>> analysisBusinessOrder(HttpServletRequest request,BusinessOrderDto param){
        if(null == param){
            param = new BusinessOrderDto();
        }
        return businessOrderPullerIntegration.analysisBusinessOrder(param);
    }
}
