package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.report.facade.constant.IntegrationConstant;
import com.bxm.report.model.constant.ReportConstant;
import com.bxm.report.model.dto.analysis.AnalysisParamsDTO;
import com.bxm.report.model.vo.analysis.*;
import com.bxm.report.service.datapark.TicketAnalysisService;
import com.bxm.report.service.utils.ExcelUtil;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/8 16:52
 * 修 改 人：
 * 日 期：
 * 描 述： 券分析控制层
 * 版 本 号： v1
 */

@Slf4j
@RestController
@RequestMapping("/ticket/analysis")
@SuppressWarnings("unchecked")
public class TicketAnalysisController extends BaseController {

    @Autowired
    private TicketAnalysisService ticketAnalysisService;

    /**
     * Description: 趋势维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/trend", method = RequestMethod.GET)
    public ResultModel<Page<AnalysisTrendVO>> trend(@RequestParam(required = false) Long ticketId,
                                                    @RequestParam(required = false) String mediaId,
                                                    @RequestParam(required = false) String adPositionId,
                                                    @RequestParam String startTime,
                                                    @RequestParam String endTime,
                                                    @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                    @RequestParam(required = false) String sortFieldName,
                                                    @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Page<AnalysisTrendVO>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_TREND));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis by trend fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 媒体维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/media", method = RequestMethod.GET)
    public ResultModel<Page<AnalysisMediaVO>> media(@RequestParam(required = false) Long ticketId,
                                                    @RequestParam(required = false) String mediaId,
                                                    @RequestParam String startTime,
                                                    @RequestParam String endTime,
                                                    @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                    @RequestParam(required = false) String sortFieldName,
                                                    @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                                                    @RequestParam(required = false) String mediaGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .mediaGroupType(mediaGroupType)
                .startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Page<AnalysisMediaVO>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_MEDIA));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis by media fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 广告类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/tagType", method = RequestMethod.GET)
    public ResultModel<Page<AnalysisTagTypeVO>> tagType(@RequestParam(required = false) String mediaId,
                                                        @RequestParam(required = false) String adPositionId,
                                                        @RequestParam String startTime,
                                                        @RequestParam String endTime,
                                                        @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                        @RequestParam(required = false) String sortFieldName,
                                                        @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Page<AnalysisTagTypeVO>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_TAG_TYPE));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis by tagType fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 区域维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/region", method = RequestMethod.GET)
    public ResultModel<Page<AnalysisRegionVO>> region(@RequestParam(required = false) Long ticketId,
                                                      @RequestParam(required = false) String mediaId,
                                                      @RequestParam(required = false) String adPositionId,
                                                      @RequestParam String startTime,
                                                      @RequestParam String endTime,
                                                      @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                      @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                      @RequestParam(required = false) String sortFieldName,
                                                      @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                                                      @RequestParam(required = false) String regionGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).regionGroupType(regionGroupType)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .regionGroupType(regionGroupType)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Page<AnalysisRegionVO>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_REGION));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis by region fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 操作系统维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/appOS", method = RequestMethod.GET)
    public ResultModel<Page<AnalysisAppOSVO>> appOS(@RequestParam(required = false) Long ticketId,
                                                    @RequestParam(required = false) String mediaId,
                                                    @RequestParam(required = false) String adPositionId,
                                                    @RequestParam String startTime,
                                                    @RequestParam String endTime,
                                                    @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                    @RequestParam(required = false) String sortFieldName,
                                                    @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Page<AnalysisAppOSVO>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_APP_OS));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis by appOS fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 支付类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/paymentType", method = RequestMethod.GET)
    public ResultModel<Page<AnalysisPaymentTypeVO>> paymentType(@RequestParam(required = false) Long ticketId,
                                                                @RequestParam(required = false) String mediaId,
                                                                @RequestParam(required = false) String adPositionId,
                                                                @RequestParam String startTime,
                                                                @RequestParam String endTime,
                                                                @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                @RequestParam(required = false) String sortFieldName,
                                                                @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Page<AnalysisPaymentTypeVO>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_PAYMENT_TYPE));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis by paymentType fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }


    //
    //  下面是图表数据的接口
    //

    /**
     * Description: 趋势维度分析--图表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/chart/trend", method = RequestMethod.GET)
    public ResultModel<Map<String, Object>> trendChart(@RequestParam(required = false) Long ticketId,
                                                                    @RequestParam(required = false) String mediaId,
                                                                    @RequestParam(required = false) String adPositionId,
                                                                    @RequestParam String startTime,
                                                                    @RequestParam String endTime,
                                                                    @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                    @RequestParam(required = false) String sortFieldName,
                                                                    @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Map<String, Object>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysisChart(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_TREND));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by trend fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 媒体维度分析--图表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/chart/media", method = RequestMethod.GET)
    public ResultModel<Map<String, Object>> mediaChart(@RequestParam(required = false) Long ticketId,
                                                                    @RequestParam(required = false) String mediaId,
                                                                    @RequestParam String startTime,
                                                                    @RequestParam String endTime,
                                                                    @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                    @RequestParam(required = false) String sortFieldName,
                                                                    @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                                                                    @RequestParam(required = false) String mediaGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).mediaGroupType(mediaGroupType)
                .startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Map<String, Object>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysisChart(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_MEDIA));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by media fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 广告类型维度分析--图表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/chart/tagType", method = RequestMethod.GET)
    public ResultModel<Map<String, Object>> tagTypeChart(@RequestParam(required = false) String mediaId,
                                                                      @RequestParam(required = false) String adPositionId,
                                                                      @RequestParam String startTime,
                                                                      @RequestParam String endTime,
                                                                      @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                      @RequestParam(required = false) String sortFieldName,
                                                                      @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Map<String, Object>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysisChart(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_TAG_TYPE));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by tagType fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 区域维度分析--图表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/chart/region", method = RequestMethod.GET)
    public ResultModel<Map<String, Object>> regionChart(@RequestParam(required = false) Long ticketId,
                                                                     @RequestParam(required = false) String mediaId,
                                                                     @RequestParam(required = false) String adPositionId,
                                                                     @RequestParam String startTime,
                                                                     @RequestParam String endTime,
                                                                     @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                     @RequestParam(required = false) String sortFieldName,
                                                                     @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                                                                     @RequestParam(required = false) String regionGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).regionGroupType(regionGroupType)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Map<String, Object>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysisChart(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_REGION));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by region fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 操作系统维度分析--图表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/chart/appOS", method = RequestMethod.GET)
    public ResultModel<Map<String, Object>> appOSChart(@RequestParam(required = false) Long ticketId,
                                                                    @RequestParam(required = false) String mediaId,
                                                                    @RequestParam(required = false) String adPositionId,
                                                                    @RequestParam String startTime,
                                                                    @RequestParam String endTime,
                                                                    @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                    @RequestParam(required = false) String sortFieldName,
                                                                    @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Map<String, Object>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysisChart(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_APP_OS));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by appOS fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    /**
     * Description: 支付类型维度分析--图表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/chart/paymentType", method = RequestMethod.GET)
    public ResultModel<Map<String, Object>> paymentTypeChart(@RequestParam(required = false) Long ticketId,
                                                                          @RequestParam(required = false) String mediaId,
                                                                          @RequestParam(required = false) String adPositionId,
                                                                          @RequestParam String startTime,
                                                                          @RequestParam String endTime,
                                                                          @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                          @RequestParam(required = false) String sortFieldName,
                                                                          @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel<Map<String, Object>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketAnalysisService.analysisChart(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_PAYMENT_TYPE));
        } catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by paymentType fail!", e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }


    //
    //  下面是列表数据导出的接口
    //

    /**
     * Description: 趋势维度分析--导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/export/trend", method = RequestMethod.GET)
    public void trendExport(@RequestParam(required = false) Long ticketId,
                            @RequestParam(required = false) String mediaId,
                            @RequestParam(required = false) String adPositionId,
                            @RequestParam String startTime,
                            @RequestParam String endTime,
                            @RequestParam(required = false) String sortFieldName,
                            @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                            HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(1).pageSize(1000)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page<AnalysisTrendVO> page = ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_TREND);
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisTrendVO.class, "趋势维度分析.xls", response);
        } catch (Exception e) {
            throw new RuntimeException("analysis export by trend fail", e);
        }
    }

    /**
     * Description: 媒体维度分析--导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/export/media", method = RequestMethod.GET)
    public void mediaExport(@RequestParam(required = false) Long ticketId,
                            @RequestParam(required = false) String mediaId,
                            @RequestParam String startTime,
                            @RequestParam String endTime,
                            @RequestParam(required = false) String sortFieldName,
                            @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                            @RequestParam(required = false) String mediaGroupType,
                            HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).mediaGroupType(mediaGroupType)
                .startTime(startTime).endTime(endTime).sortFieldName(sortFieldName).sortType(sortType).pageNum(1).pageSize(1000).build();
        try {
            Page<AnalysisMediaVO> page = ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_MEDIA);
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisMediaVO.class, "媒体维度分析.xls", response);
        } catch (Exception e) {
            throw new RuntimeException("analysis export by media fail", e);
        }
    }

    /**
     * Description: 广告类型维度分析--导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/export/tagType", method = RequestMethod.GET)
    public void tagTypeExport(@RequestParam(required = false) String mediaId,
                              @RequestParam(required = false) String adPositionId,
                              @RequestParam String startTime,
                              @RequestParam String endTime,
                              @RequestParam(required = false) String sortFieldName,
                              @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                              HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().adPositionId(adPositionId).mediaId(mediaId)
                .startTime(startTime).endTime(endTime).pageNum(1).pageSize(1000)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page<AnalysisTagTypeVO> page = ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_TAG_TYPE);
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisTagTypeVO.class, "广告类型维度分析.xls", response);
        } catch (Exception e) {
            throw new RuntimeException("analysis export by tagType fail", e);
        }
    }

    /**
     * Description: 区域维度分析--导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/export/region", method = RequestMethod.GET)
    public void regionExport(@RequestParam(required = false) Long ticketId,
                             @RequestParam(required = false) String mediaId,
                             @RequestParam(required = false) String adPositionId,
                             @RequestParam String startTime,
                             @RequestParam String endTime,
                             @RequestParam(required = false) String sortFieldName,
                             @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                             @RequestParam(required = false) String regionGroupType,
                             HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).regionGroupType(regionGroupType)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(1).pageSize(1000)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page<AnalysisRegionVO> page = ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_REGION);
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisRegionVO.class, "区域维度分析.xls", response);
        } catch (Exception e) {
            throw new RuntimeException("analysis export by region fail", e);
        }
    }

    /**
     * Description: 操作系统维度分析--导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/export/appOS", method = RequestMethod.GET)
    public void appOSExport(@RequestParam(required = false) Long ticketId,
                            @RequestParam(required = false) String mediaId,
                            @RequestParam(required = false) String adPositionId,
                            @RequestParam String startTime,
                            @RequestParam String endTime,
                            @RequestParam(required = false) String sortFieldName,
                            @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                            HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(1).pageSize(1000)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page<AnalysisAppOSVO> page = ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_APP_OS);
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisAppOSVO.class, "操作系统维度分析.xls", response);
        } catch (Exception e) {
            throw new RuntimeException("analysis export by appOS fail", e);
        }
    }

    /**
     * Description: 支付类型维度分析--导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/export/paymentType", method = RequestMethod.GET)
    public void paymentTypeExport(@RequestParam(required = false) Long ticketId,
                                  @RequestParam(required = false) String mediaId,
                                  @RequestParam(required = false) String adPositionId,
                                  @RequestParam String startTime,
                                  @RequestParam String endTime,
                                  @RequestParam(required = false) String sortFieldName,
                                  @RequestParam(required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                                  HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId)
                .adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(1).pageSize(1000)
                .sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page<AnalysisPaymentTypeVO> page = ticketAnalysisService.analysis(paramsDTO, IntegrationConstant.Analysis.ANALYSIS_TYPE_PAYMENT_TYPE);
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisPaymentTypeVO.class, "支付类型维度分析.xls", response);
        } catch (Exception e) {
            throw new RuntimeException("analysis export by paymentType fail", e);
        }
    }


    /**
     * Description: 捕获HttpMessageNotReadableException的异常
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/16 17:25
     */
    @ExceptionHandler(HttpMessageNotReadableException.class)
    public ResultModel handleBadJSONException(HttpMessageNotReadableException ex) {
        ResultModel resultModel = new ResultModel();
        resultModel.setSuccessed(false);
        resultModel.setErrorCode("500");
        resultModel.setErrorDesc("请输入正确的参数！");
        return resultModel;
    }

}
