/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.report.web.controller;


import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.TicketUrlDto;
import com.bxm.datapark.facade.ticket.model.vo.TicketUrlVo;
import com.bxm.report.facade.datapark.DataparkTicketPullerIntegration;
import com.bxm.report.model.constant.DataParkContens;
import com.bxm.report.model.constant.ReportConstant;
import com.bxm.report.model.dao.monitor.WarnConfig;
import com.bxm.report.model.enums.WarnConfigEnum;
import com.bxm.report.model.vo.ticket.TicketAppBusinessVo;
import com.bxm.report.model.vo.ticket.TicketAppVo;
import com.bxm.report.model.vo.ticket.TicketCountVo;
import com.bxm.report.model.vo.ticket.TicketDateVo;
import com.bxm.report.service.monitor.TicketWarnConfigService;
import com.bxm.report.service.monitor.WarnConfigService;
import com.bxm.report.service.report.ITicketReportService;
import com.bxm.report.service.utils.ResultModelFactory;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

/**
 * 广告券报表，控制层
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.report.TicketReportController.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 11:26:00
 * @modifier 阿导
 * @updated 2018-02-27 11:26:00
 */
@Controller
@RequestMapping("/report")
public class TicketReportController {

    private static final Logger logger = LoggerFactory.getLogger(AppReportController.class);

    @Autowired
    private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;
    @Autowired
    private ITicketReportService ticketReportService;
    
    //新增
    @Autowired
    private WarnConfigService warnConfigService;
    @Autowired
    private TicketWarnConfigService ticketWarnConfigService;
    /**
     * 查询广告券日报小时维度
     * @param certificateid
     * @param datetime
     * @param sHour
     * @param eHour
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping(value = "/ticketReportHour", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel ticketReportHour( @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                       @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                       @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                       @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                       @RequestParam(name = DataParkContens.PAGE_SIZE, required = false) Integer pageSize,
                                       @RequestParam(name = DataParkContens.PAGE_NUM, required = false) Integer pageNum,
                                       @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                       @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {
        ResultModel resultModel = dataparkTicketPullerIntegration.ticketData(certificateid,null,null,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType);
        return resultModel;
    }


    /**
     * 查询广告券日报小时维度开发者
     * @param certificateid
     * @param appKey
     * @param datetime
     * @param sHour
     * @param eHour
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping(value = "/ticketAppReportHour", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel ticketAppReportHour( @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                       @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
                                       @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                       @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                       @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                       @RequestParam(name = DataParkContens.PAGE_SIZE, required = false) Integer pageSize,
                                       @RequestParam(name = DataParkContens.PAGE_NUM, required = false) Integer pageNum,
                                       @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                       @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {
        ResultModel resultModel = dataparkTicketPullerIntegration.ticketData(certificateid,appKey,null,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType);
        return resultModel;
    }

    /**
     * 查询广告券日报小时子渠道
     * @param certificateid
     * @param appKey
     * @param business
     * @param datetime
     * @param sHour
     * @param eHour
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping(value = "/ticketBusinessReportHour", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel ticketBusinessReportHour( @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                       @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
                                       @RequestParam(name = DataParkContens.BUSINESS, required = false) String business,
                                       @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                       @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                       @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                       @RequestParam(name = DataParkContens.PAGE_SIZE, required = false) Integer pageSize,
                                       @RequestParam(name = DataParkContens.PAGE_NUM, required = false) Integer pageNum,
                                       @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                       @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {
        ResultModel resultModel = dataparkTicketPullerIntegration.ticketData(certificateid,appKey,business,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType);
        return resultModel;
    }


    @RequestMapping("/ticket")
    @ResponseBody
    public ResultModel<Page<TicketCountVo>> findTicketCount(
            @RequestParam(name = ReportConstant.DATETIME) String datetime,
            @RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
            @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
            @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
            @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
            @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
            @RequestParam(name = "ae") String ae,
            @RequestParam(name = "ticketType", required = false) Integer ticketType,
            Integer tagCode) {
        ResultModel<Page<TicketCountVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(ticketReportService.findTicketCount(datetime,scene, keyword,pageNum, pageSize,sortName, sortType,ae,ticketType,tagCode));
        } catch (Exception e) {
            logger.error("查询广告券维度失败：" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping("/ticket/app")
    @ResponseBody
    public ResultModel<Page<TicketAppVo>> findTicketAppCount(
            @RequestParam(name = ReportConstant.DATETIME) String datetime,
            @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
            @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
            @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
            @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        ResultModel<Page<TicketAppVo>> resultModel = new ResultModel<Page<TicketAppVo>>();
        try {
            //开发者json
            resultModel.setReturnValue(ticketReportService.findTicketAppCount(datetime,certificateid, keyword,pageNum, pageSize,sortName, sortType));
        } catch (Exception e) {
            logger.error("查询广告券开发者维度维度失败：" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }


    @RequestMapping("/ticket/app/business")
    @ResponseBody
    public ResultModel<Page<TicketAppBusinessVo>> findTicketAppBusinessCount(
            @RequestParam(name = ReportConstant.DATETIME) String datetime,
            @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
            @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
            @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
            @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
            @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        ResultModel<Page<TicketAppBusinessVo>> resultModel = new ResultModel<Page<TicketAppBusinessVo>>();
        try {
            resultModel.setReturnValue(ticketReportService.findTicketAppBusinessCount(datetime,certificateid,appKey, keyword,pageNum, pageSize,sortName, sortType));
        } catch (Exception e) {
            logger.error("查询广告券开发者子链接维度失败：" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping("/ticket/date")
    @ResponseBody
    public ResultModel<List<TicketDateVo>> findTicketCountDate(
            @RequestParam(name = ReportConstant.START_TIME) String startTime,
            @RequestParam(name = ReportConstant.END_TIME) String endTime,
            @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        //声明结果集
        ResultModel<List<TicketDateVo>> resultModel = new ResultModel<List<TicketDateVo>>();
        try {
            //服务层调用
            resultModel.setReturnValue(ticketReportService.findTicketCountDate(startTime, endTime, certificateid, sortName, sortType));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            logger.error("广告券按日查询失败：" + e.getMessage(), e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        //返回结果
        return resultModel;
    }
    
    @RequestMapping(value = "/ticketUrl", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel<Page<TicketUrlVo>> analysisTicketUrl(HttpServletRequest request,TicketUrlDto param){
        if(null == param){
            param = new TicketUrlDto();
        }
        try {
            //查询配置的阈值
            WarnConfig warnConfig = warnConfigService
                    .selectByConfigKey(WarnConfigEnum.TICKET_URL.getConfigKey());
            if (warnConfig != null && StringUtils.isNotBlank(warnConfig.getPropValue())) {
                String propValue = warnConfig.getPropValue();
                String[] param1 = propValue.split(",");
                if (StringUtils.isNumeric(param1[0])) {
                    param.setClickPv(Double.valueOf(param1[0]));
                }
                if (StringUtils.isNotBlank(param1[1])) {
                    String[] param2 = param1[1].split("-");
                    if (StringUtils.isNotBlank(param2[0]) && StringUtils.isNumeric(param2[0])) {
                        param.setExposureRateMin(Double.valueOf(param2[0]));
                    }
                    if (StringUtils.isNotBlank(param2[1]) && StringUtils.isNumeric(param2[1])) {
                        param.setExposureRateMax(Double.valueOf(param2[1]));
                    }
                }
            }
            //查询配置的排除广告位
            List<Long> ticketIds = ticketWarnConfigService.getAllConfigTicketId(WarnConfigEnum.TICKET_URL.getConfigKey());
            if (!CollectionUtils.isEmpty(ticketIds)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < ticketIds.size(); i++) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(ticketIds.get(i));
                }
                param.setExcludeCertificateIds(sb.toString());
            }
        } catch (Exception e) {
            logger.error("查询广告券落地页报表数据失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return dataparkTicketPullerIntegration.analysisTicketUrl(param);
    }

}
