package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.venue.model.dto.VenueReportDto;
import com.bxm.datapark.facade.venue.model.vo.VenueReportVo;
import com.bxm.report.service.datapark.VenueReportService;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 主会场报表controller
 * @author
 */
@Controller
public class VenueReportController {

    private static final Logger LOGGER = LoggerFactory.getLogger(VenueReportController.class);

    @Autowired
    private VenueReportService venueReportService;

    /**
     * 主会场报表
     * @param dto
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/venue/report",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResultModel<Page<VenueReportVo>> venueReport(VenueReportDto dto){
        ResultModel resultModel = new ResultModel();
        try{
            resultModel.setReturnValue(venueReportService.venueReport(dto));
        }catch (Exception e){
            resultModel.setSuccessed(Boolean.FALSE);
            LOGGER.error("/venue/report error ",e);
        }
        return resultModel;
    }

    /**
     * 主会场报表--活动维度
     * @param dto
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/venue/activity/report",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResultModel<Page<VenueReportVo>> venueActivityReport(VenueReportDto dto){
        ResultModel resultModel = new ResultModel();
        try{
            resultModel.setReturnValue(venueReportService.venueActivityReport(dto));
        }catch (Exception e){
            resultModel.setSuccessed(Boolean.FALSE);
            LOGGER.error("/venue/report error ",e);
        }
        return resultModel;
    }

    /**
     * 主会场报表--按日维度
     * @param dto
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/venue/date/report",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResultModel<Page<VenueReportVo>> venueDateReport(VenueReportDto dto){
        ResultModel resultModel = new ResultModel();
        try{
            resultModel.setReturnValue(venueReportService.venueDateReport(dto));
        }catch (Exception e){
            resultModel.setSuccessed(Boolean.FALSE);
            LOGGER.error("/venue/report error ",e);
        }
        return resultModel;
    }
}
