package com.bxm.report.web.exclude;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.activity.ActivityReportDto;
import com.bxm.datapark.facade.activity.ActivityReportVo;
import com.bxm.datapark.facade.order.model.dto.BusinessOrderDto;
import com.bxm.datapark.facade.order.model.vo.BusinessOrderVo;
import com.bxm.datapark.facade.position.model.dto.PositionUserPortraitDto;
import com.bxm.datapark.facade.position.model.vo.PositionUserPortraitVo;
import com.bxm.datapark.facade.venue.model.dto.VenueReportDto;
import com.bxm.datapark.facade.venue.model.vo.VenueReportVo;
import com.bxm.report.facade.datapark.*;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.base.PaginationTemp;
import com.bxm.report.model.constant.DataParkContens;
import com.bxm.report.model.constant.ReportConstant;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.dao.adposition.PositionUserPortraitNewVo;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dao.order.BusinessOrderNewVo;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.dao.venue.VenueActivityReportExcelVo;
import com.bxm.report.model.dao.venue.VenueDateReportExcelVo;
import com.bxm.report.model.dao.venue.VenueReportExcelVo;
import com.bxm.report.model.release.AnalysisDateVo;
import com.bxm.report.model.release.PutAnalysisEntityDto;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.report.model.vo.activity.ActivityVo;
import com.bxm.report.model.vo.app.*;
import com.bxm.report.model.vo.appcount.AppCountVo;
import com.bxm.report.model.vo.ticket.TicketAppBusinessVo;
import com.bxm.report.model.vo.ticket.TicketAppVo;
import com.bxm.report.model.vo.ticket.TicketCountVo;
import com.bxm.report.model.vo.ticket.TicketDateVo;
import com.bxm.report.service.datapark.DataparkActivityService;
import com.bxm.report.service.datapark.DataparkTicketService;
import com.bxm.report.service.datapark.VenueReportService;
import com.bxm.report.service.report.IAppReportService;
import com.bxm.report.service.report.ITicketReportService;
import com.bxm.report.service.utils.ExcelUtil;
import com.bxm.report.service.utils.ObjectUtils;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.dozer.Mapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dozer.Mapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p>
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/04/17 10:01
 */
@RestController
@RequestMapping("/exclude")
public class ExcludeReortController extends BaseController {

    private static final Logger                   logger = Logger.getLogger(ExcludeReortController.class);

    @Autowired
    private DataparkActivityPullerIntegration     dataparkActivityPullerIntegration;

    @Autowired
    private DataparkActivityService               dataparkActivityService;

    @Autowired
    private IAppReportService                     appReportService;

    @Autowired
    private DataparkTicketPullerIntegration       dataparkTicketPullerIntegration;

    @Autowired
    private DataparkTicketService                 dataparkTicketService;

    @Autowired
    private ITicketReportService                  ticketReportService;

    @Autowired
    private DataparkAnalysisDatePullerIntegration dataparkAnalysisDatePullerIntegration;
    
    @Autowired
    private DataparkPositionPullerIntegration  positionPullerIntegration;

    @Autowired
    private DataparkBusinessOrderPullerIntegration businessOrderPullerIntegration;

    @Autowired
    private VenueReportService venueReportService;

    @Autowired
    private Mapper mapper;

    /*
     * 导出多维度查询活动报表
     * @author wuwenquan
     * @date 2018/6/26
     * @param
     * @return
     */
    @RequestMapping(value = "/newActivityReportExport", method = RequestMethod.GET)
    public void activityReportByDateExport(HttpServletResponse response, ActivityReportDto dto) {
        List<ActivityReportVo> activityReportVos = dataparkActivityPullerIntegration.newActivityReportExport(dto);

        dataparkActivityService.newActivityReportExport(activityReportVos, response);
    }

    /**
     * 活动报表按日导出
     * 
     * @author zhangkai
     * @date 2018/2/28 15:03
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportByDateExport", method = RequestMethod.GET)
    public void activityReportByDateExport(HttpServletRequest request, HttpServletResponse response,
                                           @RequestParam(name = DataParkContens.START_TIME) String startTime,
                                           @RequestParam(name = DataParkContens.END_TIME) String endTime,
                                           @RequestParam(name = DataParkContens.ACTIVITY_ID) Long activityId,
                                           @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                           @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {
        // User user = getUser(request,response);
        List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportByDate(startTime, endTime,
                                                                                                    activityId,
                                                                                                    sortName, sortType);
        dataparkActivityService.activityReportByDateExport(activityCounts, response);
    }

    /*
     * 导出活动报表开发者维度
     * @author zhangkai
     * @date 2018/2/28 11:53
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportAppExport", method = RequestMethod.GET)
    public void activityReportAppExport(HttpServletRequest request, HttpServletResponse response,
                                        @RequestParam(required = true, name = DataParkContens.DATETIME) String datetime,
                                        @RequestParam(required = false, name = DataParkContens.KEYWORDS) String keywords,
                                        @RequestParam(required = false, name = DataParkContens.ACTIVITY_ID) Long activityId) {
        // User user = getUser(request,response);
        String json = dataparkActivityService.getAppKeys(keywords);
        List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportAppExport(datetime, json,
                                                                                                       activityId);
        dataparkActivityService.activityReportAppExport(activityCounts, response);

    }

    /*
     * 导出活动报表子链接维度
     * @author zhangkai
     * @date 2018/2/28 14:38
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportAppBusinessExport", method = RequestMethod.GET)
    public void activityReportAppBusinessExport(HttpServletRequest request, HttpServletResponse response,
                                                @RequestParam(required = true, name = DataParkContens.DATETIME) String datetime,
                                                @RequestParam(required = false, name = DataParkContens.KEYWORDS) String keywords,
                                                @RequestParam(required = false, name = DataParkContens.ACTIVITY_ID) Long activityId,
                                                @RequestParam(required = false, name = DataParkContens.APP_KEY) String appKey) {
        // User user = getUser(request,response);
        String json = dataparkActivityService.getBusiness(appKey, keywords);
        List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportAppBusinessExport(datetime,
                                                                                                               json,
                                                                                                               activityId,
                                                                                                               appKey);
        dataparkActivityService.activityReportAppBusinessExport(activityCounts, response);

    }

    /**
     * 活动报表子链接按日导出
     * 
     * @author zhangkai
     * @date 2018/2/28 15:22
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportBusinessByDateExport", method = RequestMethod.GET)
    public void activityReportBusinessByDateExport(HttpServletRequest request, HttpServletResponse response,
                                                   @RequestParam(name = DataParkContens.START_TIME) String startTime,
                                                   @RequestParam(name = DataParkContens.END_TIME) String endTime,
                                                   @RequestParam(name = DataParkContens.ACTIVITY_ID) Long activityId,
                                                   @RequestParam(name = DataParkContens.APP_KEY) String appKey,
                                                   @RequestParam(name = DataParkContens.BUSINESS) String business,
                                                   @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                                   @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {

        // User user = getUser(request,response);
        List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime,
                                                                                                            endTime,
                                                                                                            activityId,
                                                                                                            appKey,
                                                                                                            business,
                                                                                                            sortName,
                                                                                                            sortType);
        dataparkActivityService.activityReportBusinessByDateExport(activityCounts, response);
    }

    /**
     * 导出活动报表
     * 
     * @author zhangkai
     * @date 2018/2/28 11:09
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportExport", method = RequestMethod.GET)
    public String activityReportExport(HttpServletRequest request, HttpServletResponse response, ActivityReportRo activityReportRo) {
        // User user = getUser(request,response);
        if (StringUtils.isEmpty(activityReportRo.getDatetime())) {
            return "日期不能为空";
        }
        String json = dataparkActivityService.getActivityIds(activityReportRo);
        if (json == null){
            return "没有数据可以导出";
        }
        List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportExport(activityReportRo.getDatetime(), json);
        dataparkActivityService.activityReportExport(activityCounts, response);
        return "";
    }

    /**
     * 导出开发者子链接
     *
     * @param response
     * @param datetime
     * @param keyword
     * @param appKey
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/business/export")
    public void findAppBusinessCountExport(HttpServletRequest request, HttpServletResponse response,
                                           @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                           @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
                                           @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                           @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.OPEN_PV_VO) String sortName,
                                           @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType,
                                           @RequestParam(name = "onlineStart", required = false) String onlineStart,
                                           @RequestParam(name = "onlineEnd", required = false) String onlineEnd) {

        // 声明结果集
        List<AppBusinessVo> appBusinessCounts = null;
        try {
            // User user = getUser(request,response);
            // 服务层调用
            appBusinessCounts = appReportService.findAppBusinessCountExport(datetime, keyword, appKey, sortName,
                                                                            sortType, onlineStart, onlineEnd);
        } catch (Exception e) {
            // 异常情况
            logger.error("导出开发者日报按子链接失败" + e.getMessage(), e);
        }
        // 导出操作
        ExcelUtil.exportExcel(appBusinessCounts, null, null, AppBusinessVo.class, "开发者日报按子链接.xls", response);
    }

    /**
     * 导出开发者子链接按活动
     * 
     * @param datetime
     * @param appKey
     * @param business
     * @param keyword
     * @return
     * @throws IOException
     */
    @RequestMapping("/app/business/activityExport")
    public void AppBusinessActivityExport(HttpServletRequest request, HttpServletResponse response,
                                          @RequestParam(name = ReportConstant.DATETIME, required = false) String datetime,
                                          @RequestParam(name = ReportConstant.APPKEY_VO, required = false) String appKey,
                                          @RequestParam(name = ReportConstant.BUSINESS, required = false) String business,
                                          @RequestParam(name = ReportConstant.KEYWORDS, required = false) String keyword,
                                          @RequestParam(name = ReportConstant.ACTIVITY_TYPE, required = false, defaultValue = "") String activityType,
                                          @RequestParam(name = ReportConstant.ACTIVITY_PLANNER, required = false, defaultValue = "") String activityPlanner,
                                          @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
                                          @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) throws IOException {
        // User user = getUser(request,response);
        List<ActivityVo> list;
        try {
            PaginationTemp<ActivityVo> paginationTemp = appReportService.findAppBusinessActivity(keyword, datetime, appKey, business, activityType, activityPlanner, 1000, 1, sortName, sortType);
            list = paginationTemp.getList();
        }catch (Exception e) {
            logger.error("导出开发者子链接按活动数据异常！", e);
            list = Collections.emptyList();
        }
        ExcelUtil.exportExcel(list, null, null, ActivityVo.class, "开发者子渠道按活动.xls", response);
    }

    /**
     * 导出开发者子链接按日
     * 
     * @param startTime
     * @param endTime
     * @param appKey
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/business/date/export")
    public void findAppBusinessCountByDateExport(HttpServletRequest request, HttpServletResponse response,
                                                 @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                                 @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                                 @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                                 @RequestParam(name = ReportConstant.BUSINESS) String business,
                                                 @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
                                                 @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        // 声明结果集
        List<AppBusinessByDateVo> appCounts = null;
        try {
            // User user = getUser(request,response);
            // 服务层调用
            appCounts = appReportService.findAppBusinessCountByDate(appKey, business, startTime, endTime, sortName,
                                                                    sortType);
        } catch (Exception e) {
            // 异常情况
            logger.error("导出开发者子链接按日失败" + e.getMessage(), e);
        }
        // 导出操作
        ExcelUtil.exportExcel(appCounts, null, null, AppBusinessByDateVo.class, "开发者子链接日报.xls", response);
    }

    /**
     * 导出查询开发者子链接广告券
     * 
     * @param response
     * @param datetime
     * @param appKey
     * @param business
     * @param keyword
     * @return
     */
    @RequestMapping("/app/business/ticket/export")
    public void findAppBusinessTicketExport(HttpServletRequest request, HttpServletResponse response,
                                            @RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
                                            @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                            @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                            @RequestParam(name = ReportConstant.BUSINESS) String business,
                                            @RequestParam(name = ReportConstant.JSON, required = false) String keyword,
                                            @RequestParam(name = "ticketType", required = false) Integer ticketType) {
        // 声明结果集
        List<AppBusinessTicketVo> appBusinessTickets = null;
        try {
            // User user = getUser(request,response);
            // 服务层调用
            appBusinessTickets = appReportService.findAppBusinessTicketExport(datetime, appKey, business, scene,
                                                                              keyword, ticketType);
        } catch (Exception e) {
            // 异常情况
            logger.error("导出开发者子链接广告券失败" + e.getMessage(), e);
        }
        // 返回结果
        ExcelUtil.exportExcel(appBusinessTickets, null, null, AppBusinessTicketVo.class, "开发者子链接广告券.xls", response);
    }

    /**
     * 导出开发者日报按日
     * 
     * @param startTime
     * @param endTime
     * @param appKey
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/date/export")
    public void findAppCountByDateExport(HttpServletRequest request, HttpServletResponse response,
                                         @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                         @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                         @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                         @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
                                         @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        // 声明结果集
        List<AppByDateVo> appCounts = null;
        try {
            // User user = getUser(request,response);
            // 服务层调用
            appCounts = appReportService.findAppCountDate(appKey, startTime, endTime, sortName, sortType);
        } catch (Exception e) {
            // 异常情况
            logger.error("导出开发者日报按日失败" + e.getMessage(), e);
        }
        // 导出操作
        ExcelUtil.exportExcel(appCounts, null, null, AppByDateVo.class, "开发者日报按日.xls", response);
    }

    /**
     * 导出开发者日报
     *
     * @param response
     * @param datetime
     * @param keyword
     * @param sortName
     * @param sortType
     */
    @RequestMapping(value = "/app/export", method = RequestMethod.GET)
    public void getAppCountExport(HttpServletRequest request, HttpServletResponse response,
                                  @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                  @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
                                  @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
                                  @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                                  @RequestParam(name = "onlineStart", required = false) String onlineStart,
                                  @RequestParam(name = "onlineEnd", required = false) String onlineEnd) {
        // 获取当前用户
        User user = getUser(request, response);
        // 声明并实例化结果集
        List<AppCountVo> appCounts = null;
        try {
            // 调用服务层
            appCounts = appReportService.getAppCountExport(datetime, keyword, user, sortName, sortType, onlineStart,
                                                           onlineEnd);
        } catch (Exception e) {
            logger.error("导出开发者日报失败" + e.getMessage(), e);
        }
        // 导出操作
        ExcelUtil.exportExcel(appCounts, null, null, AppCountVo.class, "开发者日报.xls", response);
    }

    /**
     * 导出开发者下面的广告券,其中，只传appkey,差的是开发者按广告券维度 若appkey和Business都传，则查询的是子链接按馆告券维度 其中json，是广告券ID 集合JSON，List<Long>
     * 
     * @param response
     * @param datetime
     * @param appKey
     * @param scene
     * @param keyword
     */
    @RequestMapping("/app/ticket/export")
    public void appTicketExport(HttpServletRequest request, HttpServletResponse response,
                                @RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
                                @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword) {
        // 声明结果集
        List<AppTicketVo> appTicketCounts = null;
        try {
            // User user = getUser(request,response);
            // 服务层调用
            appTicketCounts = appReportService.findAppTicketCount(datetime, appKey, scene, keyword);

        } catch (Exception e) {
            // 异常情况
            logger.error("导出开发者下面的广告券失败" + e.getMessage(), e);
        }
        // 导出操作
        ExcelUtil.exportExcel(appTicketCounts, null, null, AppTicketVo.class, "开发者广告券日报.xls", response);
    }

    /**
     * 导出开发者下面的广告券
     * 
     * @param response
     * @param startTime
     * @param endTime
     * @param appKey
     * @param certificateid
     * @param sortName
     * @param sortType
     */
    @RequestMapping("/app/ticket/date/export")
    public void findAppTicketDateExport(HttpServletRequest request, HttpServletResponse response,
                                        @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                        @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                        @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                        @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
                                        @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
                                        @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        // 声明结果集
        List<AppTicketDateVo> appTicketCountDates = null;
        try {
            // User user = getUser(request,response);
            // 服务层调用
            appTicketCountDates = appReportService.findAppTicketCountDate(startTime, endTime, appKey, certificateid,
                                                                          sortName, sortType);
        } catch (Exception e) {
            // 异常情况
            logger.error("导出开发者下面的广告券按日失败" + e.getMessage(), e);
        }
        // 导出操作
        ExcelUtil.exportExcel(appTicketCountDates, null, null, AppTicketDateVo.class, "开发者广告券按日.xls", response);
    }

    @RequestMapping("/ticket/date/export")
    public void findTicketCountDateExport(HttpServletRequest request, HttpServletResponse response,
                                          @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                          @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                          @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
                                          @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
                                          @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType,
                                          String customExportFieldStr, Integer showIncreaseFlag) {
        List<TicketDateVo> ticketCountDates = null;
        try {
            // User user = getUser(request,response);
            ticketCountDates = ticketReportService.findTicketCountDate(startTime, endTime, certificateid, sortName,
                                                                       sortType);
        } catch (Exception e) {
            logger.error("导出广告券按日失败：" + e.getMessage(), e);
        }
        ExcelUtil.customFieldExport(ticketCountDates, TicketDateVo.class, customExportFieldStr, showIncreaseFlag,
                                    "广告券按日.xls", response);
    }

    @RequestMapping("/ticket/app/export")
    public void findTicketAppCountExport(HttpServletRequest request, HttpServletResponse response,
                                         @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                         @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
                                         @RequestParam(name = ReportConstant.JSON, required = false) String keyword,
                                         String customExportFieldStr, Integer showIncreaseFlag) {
        List<TicketAppVo> ticketAppCounts = null;
        try {
            // User user = getUser(request,response);
            ticketAppCounts = ticketReportService.findTicketAppCountExport(datetime, certificateid, keyword);
        } catch (Exception e) {
            logger.error("查询广告券维度失败：" + e.getMessage(), e);
        }
        ExcelUtil.customFieldExport(ticketAppCounts, TicketAppVo.class, customExportFieldStr, showIncreaseFlag,
                                    "广告券开发者.xls", response);
    }

    @RequestMapping("/ticket/app/business/export")
    public void findTicketAppBusinessCountExport(HttpServletRequest request, HttpServletResponse response,
                                                 @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                                 @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
                                                 @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                                 @RequestParam(name = ReportConstant.JSON, required = false) String keyword,
                                                 String customExportFieldStr, Integer showIncreaseFlag) {
        List<TicketAppBusinessVo> ticketAppCounts = null;
        try {
            // User user = getUser(request,response);
            ticketAppCounts = ticketReportService.findTicketAppBusinessCountExport(datetime, certificateid, appKey,
                                                                                   keyword);
        } catch (Exception e) {
            logger.error("导出广告券开发者子链接维度失败：" + e.getMessage(), e);
        }
        ExcelUtil.customFieldExport(ticketAppCounts, TicketAppBusinessVo.class, customExportFieldStr, showIncreaseFlag,
                                    "广告券开发者子链接.xls", response);
    }

    /**
     * 导出广告券日报小时维度子链接
     * 
     * @param certificateid
     * @param appKey
     * @param business
     * @param datetime
     * @param sHour
     * @param eHour
     * @param response
     */
    @RequestMapping(value = "/ticketReportBusinessHourExport", method = RequestMethod.GET)
    public void ticketReportBusinessHourExport(HttpServletRequest request, HttpServletResponse response,
                                               @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                               @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
                                               @RequestParam(name = DataParkContens.BUSINESS, required = false) String business,
                                               @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                               @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                               @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                               String customExportFieldStr, Integer showIncreaseFlag) {
        // User user = getUser(request,response);
        List<TicketCountCommon> list = dataparkTicketPullerIntegration.ticketHoursExport(datetime, certificateid,
                                                                                         appKey, business, sHour,
                                                                                         eHour);
        dataparkTicketService.ticketDataExport(list, customExportFieldStr, showIncreaseFlag, response);
    }

    /**
     * 导出广告券日报小时维度开发者
     * 
     * @param certificateid
     * @param appKey
     * @param datetime
     * @param sHour
     * @param eHour
     * @param response
     */
    @RequestMapping(value = "/ticketReportAppHourExport", method = RequestMethod.GET)
    public void ticketReportAppHourExport(HttpServletRequest request, HttpServletResponse response,
                                          @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                          @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
                                          @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                          @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                          @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                          String customExportFieldStr, Integer showIncreaseFlag) {
        // User user = getUser(request,response);
        List<TicketCountCommon> list = dataparkTicketPullerIntegration.ticketHoursExport(datetime, certificateid,
                                                                                         appKey, null, sHour, eHour);
        dataparkTicketService.ticketDataExport(list, customExportFieldStr, showIncreaseFlag, response);
    }

    /**
     * 导出广告券日报小时维度
     * 
     * @param certificateid
     * @param datetime
     * @param sHour
     * @param eHour
     * @param response
     */
    @RequestMapping(value = "/ticketReportHourExport", method = RequestMethod.GET)
    public void ticketReportHourExport(HttpServletRequest request, HttpServletResponse response,
                                       @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                       @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                       @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                       @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                       String customExportFieldStr, Integer showIncreaseFlag) {
        // User user = getUser(request,response);
        List<TicketCountCommon> list = dataparkTicketPullerIntegration.ticketHoursExport(datetime, certificateid, null,
                                                                                         null, sHour, eHour);
        dataparkTicketService.ticketDataExport(list, customExportFieldStr, showIncreaseFlag, response);
    }

    @RequestMapping("/ticket/export")
    public void findTicketCount(HttpServletRequest request, HttpServletResponse response,
                                @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                @RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
                                @RequestParam(name = ReportConstant.JSON, required = false) String keyword,
                                @RequestParam(name = "ae", required = false) String ae,
                                @RequestParam(name = "ticketType", required = false) Integer ticketType,
                                String customExportFieldStr, Integer showIncreaseFlag, Integer tagCode) {
        List<TicketCountVo> ticketCounts = null;
        try {
            // User user = getUser(request,response);
            ticketCounts = ticketReportService.findTicketCountExport(datetime, scene, keyword, ae, ticketType, tagCode);
        } catch (Exception e) {
            logger.error("导出广告券维度失败：" + e.getMessage(), e);
        }
        ExcelUtil.customFieldExport(ticketCounts, TicketCountVo.class, customExportFieldStr, showIncreaseFlag,
                                    "广告券.xls", response);

    }

    /**
     * 导出开发者日报根据不同角色看到不同数据（bd只能看到自己的媒体）
     * 
     * @param startTime
     * @param startTime
     * @param keyword
     * @return
     */
    @RequestMapping(value = "/app/appCountSumByDateExport", method = RequestMethod.GET)
    public void findAppCountSumByDate(HttpServletRequest request, HttpServletResponse response,
                                      @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                      @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                      @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword) {
        // 获取当前用户
        User user = getUser(request, response);
        // 声明并实例化结果集
        List<AppCountVo> appCounts = null;
        try {
            // 调用服务层
            appCounts = appReportService.appCountSumByDateExport(startTime, endTime, keyword, user);
        } catch (Exception e) {
            logger.error("导出开发者日报失败" + e.getMessage(), e);

        }
        ExcelUtil.exportExcel(appCounts, null, null, AppCountVo.class, "开发者合计按日.xls", response);
    }

    /**
     * 开发者日报，子链接，广告券，按日导出
     * 
     * @param response 响应对象
     * @param startTime 开始日期
     * @param endTime 结束日期
     * @param appKey appKey
     * @param business 子链接ID
     * @param certificateid 券ID
     * @param sortName 排序名
     * @param sortType 排序方式
     */
    @RequestMapping(value = "/app/business/ticketByDayExport", method = RequestMethod.GET)
    public void findAppCountSumByDate(HttpServletResponse response,
                                      @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                      @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                      @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                      @RequestParam(name = ReportConstant.BUSINESS) String business,
                                      @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
                                      @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
                                      @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        // 声明并实例化结果集
        List<AppBusinessTicketDateVo> appBusinessTicketDateReport = null;
        try {
            // 调用服务层
            appBusinessTicketDateReport = appReportService.findAppBusinessTicketDateReport(startTime, endTime, appKey,
                                                                                           certificateid, sortName,
                                                                                           sortType, business);
        } catch (Exception e) {
            logger.error("导出开发者-子链接-广告券-日报失败" + e.getMessage(), e);

        }
        ExcelUtil.exportExcel(appBusinessTicketDateReport, null, null, AppBusinessTicketDateVo.class, "开发者子链接广告券按日.xls",
                              response);
    }

    /**
     * 报表导出
     * 
     * @param putAnalysisEntityDto
     * @param response
     */
    @RequestMapping(value = "/analysis/export/AllList", method = RequestMethod.GET)
    public void findAnalysisPutDateExport(PutAnalysisEntityDto putAnalysisEntityDto, HttpServletResponse response) {
        ResultModel resultModel = null;
        try {
            putAnalysisEntityDto.setPage(false);

            // obj 转化map
            Map<String, Object> map = ObjectUtils.objectToMap(putAnalysisEntityDto);
            resultModel = dataparkAnalysisDatePullerIntegration.pullAnalysisPutDateCount(map);
            Pagination pagination = (Pagination) resultModel.getReturnValue();

            if (pagination.getList().size() > 0) {
                ExcelUtil.exportExcel(pagination.getList(), null, null, pagination.getList().get(0).getClass(),
                                      "投放分析报表.xls", response);
            } else {
                ExcelUtil.exportExcel(pagination.getList(), null, null, AnalysisDateVo.class, "投放分析报表.xls", response);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /**
     * 活动报表子链接按日导出
     * 
     * @author zhangkai
     * @date 2018/2/28 15:22
     * @param
     * @return
     */
    @RequestMapping(value = "/app/business/activityByDayExport", method = RequestMethod.GET)
    public void appBusinessActivityDateReportExport(HttpServletResponse response,
                                                    @RequestParam(name = DataParkContens.START_TIME) String startTime,
                                                    @RequestParam(name = DataParkContens.END_TIME) String endTime,
                                                    @RequestParam(name = DataParkContens.ACTIVITY_ID) Long activityId,
                                                    @RequestParam(name = DataParkContens.APP_KEY) String appKey,
                                                    @RequestParam(name = DataParkContens.BUSINESS) String business,
                                                    @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                                    @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {

        List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime,
                                                                                                            endTime,
                                                                                                            activityId,
                                                                                                            appKey,
                                                                                                            business,
                                                                                                            sortName,
                                                                                                            sortType);
        dataparkActivityService.activityReportBusinessByDateExport(activityCounts, response);
        dataparkActivityService.appBusinessActivityDateReportExport(activityCounts, response);
    }
    
    /**
    * @Title: exportPositionUserPortrait
    * @Description: 导出广告位用户画像
    * @return void
     */
    @RequestMapping(value = "/positionReport/exportUserPortrait", method = RequestMethod.GET)
    public void exportPositionUserPortrait(HttpServletRequest request,
            HttpServletResponse response,
            PositionUserPortraitDto param){
        if(null == param){
            param = new PositionUserPortraitDto();
        }
        ResultModel<List<PositionUserPortraitVo>> resultModel = positionPullerIntegration.exportPositionUserPortrait(param);
        List<PositionUserPortraitVo> list = null;
        if(resultModel != null && resultModel.isSuccessed() && !CollectionUtils.isEmpty(resultModel.getReturnValue())){
            list = resultModel.getReturnValue();
        }else{
            list = new ArrayList<PositionUserPortraitVo>();
        }
        List<PositionUserPortraitNewVo> resultList = null;
        if(!CollectionUtils.isEmpty(list)){
            resultList = new ArrayList<PositionUserPortraitNewVo>();
            PositionUserPortraitNewVo newVo = null;
            for(PositionUserPortraitVo record : list){
                newVo = new PositionUserPortraitNewVo();
                BeanUtils.copyProperties(record, newVo);
                resultList.add(newVo);
            }
        }else{
            resultList = new ArrayList<PositionUserPortraitNewVo>();
        }
        ExcelUtil.exportExcel(resultList, null, null, PositionUserPortraitNewVo.class, "广告位用户画像报表.xls", response);
    }

    /**
     *
    * @Title: exportUserOrder
    * @Description: 导出用户订单数据
    * @return void
     */
    @RequestMapping(value = "/businessOrderReport/exportUserOrder", method = RequestMethod.GET)
    public void exportUserOrder(HttpServletRequest request,
            HttpServletResponse response,
            BusinessOrderDto param){
        if(null == param){
            param = new BusinessOrderDto();
        }
        ResultModel<List<BusinessOrderVo>> resultModel = businessOrderPullerIntegration.exportUserOrder(param);
        List<BusinessOrderVo> list = null;
        if(resultModel != null && resultModel.isSuccessed() && !CollectionUtils.isEmpty(resultModel.getReturnValue())){
            list = resultModel.getReturnValue();
        }else{
            list = new ArrayList<BusinessOrderVo>();
        }
        List<BusinessOrderNewVo> resultList = null;
        if(!CollectionUtils.isEmpty(list)){
            resultList = new ArrayList<BusinessOrderNewVo>();
            BusinessOrderNewVo newVo = null;
            for(BusinessOrderVo record : list){
                newVo = new BusinessOrderNewVo();
                BeanUtils.copyProperties(record, newVo);
                resultList.add(newVo);
            }
        }else{
            resultList = new ArrayList<BusinessOrderNewVo>();
        }
        ExcelUtil.exportExcel(resultList, null, null, BusinessOrderNewVo.class, "货到订单报表.xls", response);
    }



    /**
     * 主会场报表导出
     * @param response
     * @param dto
     */
    @RequestMapping(value = "/venue/exportVenueReport")
    public void exportVenueReport(HttpServletResponse response, VenueReportDto dto){
        dto.setPageNum(1);
        dto.setPageSize(Integer.MAX_VALUE);
        Page<VenueReportVo> venueReportVoPage = venueReportService.venueReport(dto);
        List<VenueReportExcelVo> list = new ArrayList<>();
        if(!CollectionUtils.isEmpty(venueReportVoPage.getList())){
            for(VenueReportVo rs : venueReportVoPage.getList()){
                VenueReportExcelVo newVo = new VenueReportExcelVo();
                BeanUtils.copyProperties(rs, newVo);
                list.add(newVo);
            }
        }
        ExcelUtil.exportExcel(list, null, null, VenueReportExcelVo.class, "聚合页报表.xls", response);
    }

    /**
     * 主会场活动报表导出
     * @param response
     * @param dto
     */
    @RequestMapping(value = "/venue/exportVenueActivityReport")
    public void exportVenueActivityReport(HttpServletResponse response, VenueReportDto dto){
        dto.setPageNum(1);
        dto.setPageSize(Integer.MAX_VALUE);
        Page<VenueReportVo> venueReportVoPage = venueReportService.venueActivityReport(dto);
        List<VenueActivityReportExcelVo> list = new ArrayList<>();
        if(!CollectionUtils.isEmpty(venueReportVoPage.getList())){
            for(VenueReportVo rs : venueReportVoPage.getList()){
                VenueActivityReportExcelVo newVo = new VenueActivityReportExcelVo();
                BeanUtils.copyProperties(rs, newVo);
                list.add(newVo);
            }
        }
        ExcelUtil.exportExcel(list, null, null, VenueActivityReportExcelVo.class, "聚合页活动报表.xls", response);
    }

    /**
     * 主会场按日报表导出
     * @param response
     * @param dto
     */
    @RequestMapping(value = "/venue/exportVenueDateReport")
    public void exportVenueDateReport(HttpServletResponse response,  VenueReportDto dto){
        dto.setPageNum(1);
        dto.setPageSize(Integer.MAX_VALUE);
        Page<VenueReportVo> venueReportVoPage = venueReportService.venueDateReport(dto);
        List<VenueDateReportExcelVo> list = new ArrayList<>();
        if(!CollectionUtils.isEmpty(venueReportVoPage.getList())){
            for(VenueReportVo rs : venueReportVoPage.getList()){
                VenueDateReportExcelVo newVo = new VenueDateReportExcelVo();
                BeanUtils.copyProperties(rs, newVo);
                list.add(newVo);
            }
        }
        ExcelUtil.exportExcel(list, null, null, VenueDateReportExcelVo.class, "聚合页按日报表.xls", response);
    }
}

