package com.bxm.counter.facade.ticket;

import com.bxm.warcar.utils.DateHelper;

import java.io.Serializable;

/**
 * <p>CountInfo消息</p>
 *
 * @Description: AwradCountInfO用于反作弊操作的消息
 * @Author: JandMin
 * @Date: 2018/7/20
 */
public class MonitorInfo implements Serializable {

    private static final long serialVersionUID = -3566166222307889704L;

    private String appKey;
    private Long ticketId;
    private String business;
    private Long activityId;
    private String origin;
    private String userAgent;
    private String dateTime = DateHelper.getDateFromToday(0,DateHelper.PATTERN_STR10);

    /**
     * 请求签名：request.getHeader("Authorization")
     */
    private String sign;
    /**
     * 请求时间戳:request.getParameter("timestamp")
     */
    private String timestamp;
    /**
     * request中所有的参数转换后的签名，且不包括名称为sign和值为null参数
     */
    private String parametersSign;

    public String getParametersSign() {
        return parametersSign;
    }

    public void setParametersSign(String parametersSign) {
        this.parametersSign = parametersSign;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }
}
