/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.api.ticket.kuaishou;

import com.bxm.adscounter.facade.model.kuaishou.KuaishouTrackerDto;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.UrlHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kuaishou"})
public class KuaishouTrackerController {
    private static final Logger log = LoggerFactory.getLogger(KuaishouTrackerController.class);
    private final Updater updater;

    public KuaishouTrackerController(Updater updater) {
        this.updater = updater;
    }

    @GetMapping(value={"/click_tracker"})
    public ResponseEntity<Object> clickTracker(KuaishouTrackerDto kuaishouTrackerDto) {
        this.clickTracker0(kuaishouTrackerDto);
        return ResponseEntity.ok().build();
    }

    private void clickTracker0(KuaishouTrackerDto kuaishouTrackerDto) {
        String callback = kuaishouTrackerDto.getCallback();
        if (StringUtils.isBlank((CharSequence)callback)) {
            log.info("Empty value for callback!");
            return;
        }
        String url = UrlHelper.urlDecode((String)callback);
        String cbvalue = UrlHelper.getFirstValueOfParamName((String)url, (String)"callback");
        if (StringUtils.isBlank((CharSequence)cbvalue)) {
            log.info("Cannot found value of callback at url {}", (Object)url);
            return;
        }
        this.updater.update(this.key(cbvalue), (Object)kuaishouTrackerDto, 600);
        if (log.isDebugEnabled()) {
            log.debug("Updated: {}", (Object)cbvalue);
        }
    }

    private KeyGenerator key(String cbvalue) {
        return () -> KeyBuilder.build((Object[])new Object[]{"tracker", "kuaishou", cbvalue});
    }
}

