package com.bxm.adscounter.facade.model;

import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * <p> countInfo接口参数类 </p>
 */
@Data
public class TicketCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;
    /**
     * 用户IP
     */
    private String ipAddress;

    /**
     * 商家标志
     */
    @ValidateNotNull
    @DefaultValue("mistake_appKey")
    @ValidateLength(min = 32,max = 32)
    private String appkey;

    /**
     * 业务类型
     */
    @ValidateNotNull
    @DefaultValue("money")
    private String business;

    /**
     * 流水号(modelName)
     */
    private String spm;

    /**
     * Andriod IMEI(imei)
     */
    @ValidateImeiOrIdfa
    private String i;

    /**
     * IOS IDFA
     */
    @ValidateImeiOrIdfa
    private String f;

    /**
     * 用户token
     */
    @ValidateNotNull
    @DefaultValue("mistake_uid")
    private String uid;

    /**
     * 设备类型:1 Android;2 IOS;3 web
     */
    @ValidateNotNull
    @DefaultValue("-1")
    private Integer appos;

    /**
     * 活动ID
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Long activityid;

    /**
     * 模块类型modelType
     */
    @ValidateNotNull
    @DefaultValue("90")
    private Integer modeltype;

    /**
     * 奖品类型awardType
     */
    private Integer awardtype;

    /**
     * 奖品ID(旧名:ticketId)
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Long preid;

    /**
     * 说明
     */
    private String remark;

    /**
     * 客户端标识:1 微信; 2 支付宝;0 其它
     */
    private String ua;

    /**
     * 弹窗类型：0 活动出券;1 首页弹窗;2 挽留弹窗
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Integer scene;

    /**
     * 是否阿里支付isAli:1 是, 0 否
     */
    private String isali;

    /**
     * 当前点击位置：当前点击X轴
     */
    private String random1;

    /**
     * 当前点击位置：当前点击y轴
     */
    private String random2;

    /**
     * 设置宽高，用于统计
     */
    private String random3;

    /**
     * 弹窗ID
     */
    private String popupId;

    /**
     * 素材ID
     */
    private String assetsId;

    /**
     * 请求Header内容
     */
    private String origin;

    /**
     * 本次点击实际出价
     */
    private Integer offerPrice;

    private String referrer;
    private String userAgent;
    /**
     * 统计的唯一标识：如果billid为null则为uuid
     */
    private String countId;

    /**
     * 签名手否正确
     */
    private String remark3;

    /**
     * 是否直投 1：直投  0或者空：非直投
     */
    private Integer direct;
    /**
     *  预留字段ext
     */
    private String ext;

}
