package com.bxm.adscounter.facade;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.adscounter.facade.model.*;

/**
 * <p> 广告券相关统计接口 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/25
 */
@FeignClient(AdscounterConstants.SERVICE_NAME)
public interface TicketCounterService {
    /**
     * 保存广告券统计数据
     * @date: 2018/7/25
     * @param ticketCounterRequest
     * @return java.lang.String
     */
    @RequestMapping("/saveTicketCount")
    Response saveTicketCountMsg2(@RequestBody TicketCounterRequest ticketCounterRequest) throws NoStatisticsException;

    /**
     * 保存广告组统计数据
     * @date: 2018/8/9
     * @param adGroupMsg
     * @return void
     * @throws
     */
    @RequestMapping("/saveGroupCount")
    void saveGroupCountMsg(@RequestBody AdGroupCountMsg adGroupMsg) throws Exception;

    /**
     * <p>保存ADX统计数据</p>
     * @date: 2019/7/25
     *
     * @param ticketCountMsg
     * @return com.bxm.adscounter.facade.model.Response
     */
    @RequestMapping("/saveAdxCount")
    Response saveAdxCountMsg(@RequestBody AdxTicketCountMsgDto ticketCountMsg) throws NoStatisticsException;

    /**
     * <p>保存ADX回传激活数据</p>
     *
     * @param ticketCountMsg
     * @return com.bxm.adscounter.facade.model.Response
     */
    @RequestMapping("/saveAdxCallback")
    Response saveAdxCallback(@RequestBody AdxAdvertiserCountMsgDto ticketCountMsg) throws NoStatisticsException;

    /**
     * <p>保存激励视频统计数据</p>
     * @date: 2019/7/25
     *
     * @param ticketCountMsg
     * @return com.bxm.adscounter.facade.model.Response
     */
    @RequestMapping("/saveInspireVideoCount")
    Response saveInspireVideoCountMsg(@RequestBody InspireVideoTicketCountMsgDto ticketCountMsg) throws NoStatisticsException;
}
