package com.bxm.adscounter.facade.model;

import com.bxm.warcar.utils.DateHelper;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>CountInfo消息</p>
 *
 * @Description: AwradCountInfO用于反作弊操作的消息
 * @Author: JandMin
 * @Date: 2018/7/20
 */
@Data
public class AntiCheat implements Serializable {

    private static final long serialVersionUID = -3566166222307889704L;

    private String appKey;
    private Long ticketId;
    private String business;
    private Long activityId;
    private String origin;
    private String userAgent;
    private String dateTime = DateHelper.getDateFromToday(0,DateHelper.PATTERN_STR10);

    private String sign;    // 请求签名：request.getHeader("Authorization")
    private String timestamp;   // 请求时间戳:request.getParameter("timestamp")
    private String parametersSign;  // request中所有的参数转换后的签名，且不包括名称为sign和值为null参数
}
