package com.bxm.adscounter.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>激励视频-埋点接口参数类 </p>
 */
@Data
public class InspireVideoTicketCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;

    public final static String PLACE_TIMESTAMP = "____TIMESTAMP____";
    public final static String PLACE_IP = "____IP____";
    public final static String PLACE_OS = "____OS____";
    public final static String PLACE_UA = "____UA____";
    public final static String PLACE_IMEI = "____IMEI____";
    public final static String PLACE_IDFA = "____IDFA____";

    /**
     * 广告请求ID
     */
    @ValidateNotNull
    private String request_id;
    /**
     * 广告券ID
     */
    @ValidateNotNull
    private Long ad_id;
    /**
     * 广告位ID
     */
    @ValidateNotNull
    private String position;
    /**
     * 触发上报时间戳，如：1574218723148
     */
    private String timestamp;
    /**
     * 视频播放IP地址
     */
    private String ip;
    /**
     * 操作系统
     */
    private String os;
    /**
     * UA信息
     */
    private String ua;
    /**
     * IMEI/IMEI MD5
     */
    private String imei;
    /**
     * IDFA/IDFA MD5
     */
    private String idfa;
    /**
     * 埋点类型
     */
    @ValidateNotNull
    private Integer m_type;
    /**
     * 变现猫ID
     */
    private String bxm_id;

}
