package com.bxm.adscounter.facade.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 端点服务处理后的返回对象。
 * @author allen
 * @date 2019/3/8
 * @since 1.0.0
 */
public class Response implements Serializable {

    private static final long serialVersionUID = -3778292562687577804L;
    /**
     * 订单号，以前的bxm_id、countId
     */
    private String orderId;
    /**
     * 本次出价（单位：厘）
     */
    private String offerPrice;

    public Response() {
    }

    public Response(String orderId) {
        this.orderId = orderId;
    }

    public Response(String orderId, String offerPrice) {
        this.orderId = orderId;
        this.offerPrice = offerPrice;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOfferPrice() {
        return offerPrice;
    }

    public void setOfferPrice(String offerPrice) {
        this.offerPrice = offerPrice;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
