package com.bxm.adscounter.facade.mt;

/**
 * Model types
 * @author allen
 * @date 2019/3/8
 * @since 1.0.0
 */
public enum Mt {

    /** 不明的 */
    _OTHER(-99, -99, -99),
    /** 活动页曝光 */
    _3(3, 3001, 3301),
    /** 参与活动 */
    _4(4, 4001, 4001),
    /** 请求发券 */
    _5(5, 5001, 5101),
    /** 广告曝光 */
    _6(6, 6002, 6101),
    /** 广告点击 */
    _7(7, 7102, 7102),
    /** 活动中间页曝光 */
    _9(9, 9001, 9001),

    /** ADX-请求 */
    _100(100, 12001, 12001),
    /** ADX-竞量 */
    _101(101, 12002, 12002),
    /** ADX-互动素材曝光 */
    _102(102, 12003, 12003),
    /** ADX-互动素材点击 */
    _103(103, 12004, 12004),
    /** ADX-直投素材曝光 */
    _104(104, 12003, 12003),
    /** ADX-直投素材点击 */
    _105(105, 12004, 12004),
    /** ADX-原生视频开始播放 */
    _106(106, 12005, 12005),
    /** ADX-原生视频结束播放 */
    _107(107, 12006, 12006),
    /** ADX-广告主api效果监测--激活app */
    _108(108, 12007, 12007),
    /** ADX-广告主api效果监测--注册账号 */
    _109(109, 12008, 12008),
    /** ADX-广告主api效果监测--激活账号 */
    _110(110, 12009, 12009),
    /** ADX-广告主api效果监测--登录账号 */
    _111(111, 12010, 12010),
    /** ADX-广告主api效果监测--用户付费 */
    _112(112, 12011, 12011),
    /** ADX-赢价 */
    _113(113, 12012, 12012),


    /** 激励视频-广告曝光未完成 */
    _200(200, 13003, 13003),
    /** 激励视频-继续观看点击 */
    _201(201, 13004, 13004),
    /** 激励视频-广告曝光完成 */
    _202(202, 13005, 13005),
    /** 激励视频-广告加载完成 */
    _203(203, 13008, 13008),
    /** 激励视频-关闭按钮点击 */
    _204(204, 13009, 13009),
    /** 激励视频-应用开始下载 */
    _205(205, 13010, 13010),
    /** 激励视频-应用下载完成 */
    _206(206, 13011, 13011),
    /** 激励视频-应用安装完成 */
    _207(207, 13012, 13012),
    /** 激励视频-广告曝光异常 */
    _208(208, 13013, 13013),
    /** 激励视频-视频播放页点击 */
    _209(209, 13014, 13014),
    /** 激励视频-播放结束页点击 */
    _210(210, 13015, 13015),
    /** 激励视频-视频入口曝光 */
    _211(211, 13016, 13016),
    /** 激励视频-视频入口点击 */
    _212(212, 13017, 13017),
    /** 激励视频-视频播放到1/4 */
    _213(213, 13018, 13018),
    /** 激励视频-视频播放到1/2 */
    _214(214, 13019, 13019),
    /** 激励视频-视频播放到3/4 */
    _215(215, 13020, 13020),

    /** 广告中间页曝光 */
    _7103(7103, 7103, 7103),

    //新埋点接口
    /** 入口点击 */
    _11102(11102, -99, -99),
    /** 内容加载 */
    _11103(11103, -99, -99),
    /** 直接关闭 */
    _11104(11104, -99, -99),
    /** 下载APP */
    _11201(11201, -99, -99),
    /** 安装APP */
    _11202(11202, -99, -99),
    /** 关闭广告 */
    _11106(11106, -99, -99),
    /** 重复点开广告 */
    _11107(11107, -99, -99);

    private int original;
    private int dotV1;
    private int dotV2;

    Mt(int original, int dotV1, int dotV2) {
        this.original = original;
        this.dotV1 = dotV1;
        this.dotV2 = dotV2;
    }

    public int getOriginal() {
        return original;
    }

    public int getDotV1() {
        return dotV1;
    }

    public int getDotV2() {
        return dotV2;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain Mt#_OTHER _OTHER}
     */
    public static Mt of(Integer original) {
        Mt[] values = Mt.values();
        for (Mt value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
