package com.bxm.adscounter.facade;

import java.util.Objects;

/**
 * ADX枚举<br/>
 *
 * @author kerry.jiang
 * @date 2020/1/17 10:48
 */
public enum AdxEnum {
    
    /** 未知 */
    OTHER("-1", "未知"),
    
    /** 搜狗 */
    SOGOU("1", "搜狗"),
    /** 美团 */
    MEITUAN("5", "美团"),
    /** 变现猫 */
    BXM("6", "变现猫"),
    ;

    private String id;
    private String desc;

    AdxEnum(String id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    public String getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据原值返回枚举
     * @param id 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain null}
     */
    public static AdxEnum of(String id) {
        AdxEnum[] values = values();
        for (AdxEnum value : values) {
            if (Objects.equals(id, value.getId())) {
                return value;
            }
        }
        return OTHER;
    }
}
