package com.bxm.adscounter.facade;

import java.util.Objects;

/**
 * 盘古的ADX枚举<br/>
 *
 * @author kerry.jiang
 * @date 2020/1/17 10:48
 */
public enum PanguAdxEnum {

    /** 未知 */
    OTHER("-1", "未知"),

    /** 百度 */
    BAIDU("1", "百度"),
    /** 变现猫 */
    BXM("2", "变现猫"),
    ;

    private String id;
    private String desc;

    PanguAdxEnum(String id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    public String getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据原值返回枚举
     * @param id 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain null}
     */
    public static PanguAdxEnum of(String id) {
        PanguAdxEnum[] values = values();
        for (PanguAdxEnum value : values) {
            if (Objects.equals(id, value.getId())) {
                return value;
            }
        }
        return OTHER;
    }
}
