package com.bxm.adscounter.facade;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.adscounter.facade.model.*;

/**
 * 广告券相关统计接口-盘古<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/18 11:01
 */
@FeignClient(AdscounterConstants.SERVICE_NAME)
public interface PanguCounterService {

    /**
     * <p>保存盘古统计数据</p>
     * @date: 2021/6/18
     *
     * @param ticketCountMsg
     * @return com.bxm.adscounter.facade.model.Response
     */
    @RequestMapping("/savePanguCount")
    Response savePanguCountMsg(@RequestBody PanguTicketCountMsgDto ticketCountMsg) throws NoStatisticsException;
}
