package com.bxm.adscounter.facade;

/**
 * 数据监测上报类型
 * @author kerry.jiang
 * @date 2019/6/14
 * @since 1.0.0
 */
public enum S2sTrackType {

    /** 曝光 */
    _1(1, "曝光"),
    /** 点击 */
    _2(2, "点击"),
    /** 开始播放 */
    _3(3, "开始播放"),
    /** 播放完成 */
    _4(4, "播放完成"),
    ;

    /**
     * 上报类型
     */
    private int original;
    /**
     * 上报类型名称
     */
    private String name;

    S2sTrackType(int original, String name) {
        this.original = original;
        this.name = name;
    }

    public int getOriginal() {
        return original;
    }

    public String getName() {
        return name;
    }
}
