package com.bxm.adscounter.facade.model;

import java.io.Serializable;

import com.bxm.adscounter.facade.mt.AdxCallbackMt;
import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;

/**
 * <p>广告主效果监测参数类 </p>
 */
@Data
public class AdxAdvertiserCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;
    /**
     * 模块类型modelType
     * @see AdxCallbackMt#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * 请求日期时间戳
     */
    private Long time;
    /**
     * IEMI信息
     */
    private String imei;
    /**
     * 安卓ID
     */
    private String anid;
    /**
     * 第三方匿名设备识别号（暂时用不上）
     */
    private String oaid;
    /**
     * IDFA信息
     */
    private String idfa;
    /**
     * 用户IP
     */
    private String ip;
    /**
     * User Agent
     */
    private String ua;
    /**
     * MAC地址
     */
    private String mac;
    /**
     * 应用唯一标识
     * 安卓为包名，IOS为number ID
     */
    private String pkn;

}
