package com.bxm.adscounter.facade.model;

import java.io.Serializable;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;

/**
 * 激励视频埋点-对外API（SSP专属）<br/>
 *
 * @author kerry.jiang
 * @date 2020/10/10 9:30
 */
@Data
public class InspireVideoSspCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;

    public final static String PLACE_TIMESTAMP = "__TIMESTAMP__";
    public final static String PLACE_IP = "__IP__";
    public final static String PLACE_OS = "__OS__";
    public final static String PLACE_UA = "__UA__";
    public final static String PLACE_IMEI = "__IMEI__";
    public final static String PLACE_IDFA = "__IDFA__";

    /**
     * 广告请求ID
     */
    @ValidateNotNull
    private String request_id;
    /**
     * 广告券ID
     */
    @ValidateNotNull
    private Long ad_id;
    /**
     * 广告券素材ID
     */
    private String creative_id;
    /**
     * 广告位ID
     */
    @ValidateNotNull
    private String position;
    /**
     * 触发上报时间戳，如：1574218723148
     */
    private String timestamp;
    /**
     * 视频播放IP地址
     */
    private String ip;
    /**
     * 操作系统
     */
    private String os;
    /**
     * UA信息
     */
    private String ua;
    /**
     * IMEI/IMEI MD5
     */
    private String imei;
    /**
     * IDFA/IDFA MD5
     */
    private String idfa;
    /**
     * 埋点类型
     */
    @ValidateNotNull
    private Integer m_type;
    /**
     * 变现猫ID
     */
    private String bxm_id;


    /**
     * 设备加密后的参数
     */
    private String did;

    private String uid;
}
