package com.bxm.adscounter.facade.model;

import java.io.Serializable;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;

/**
 * 盘古-埋点接口参数类<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/18 9:49
 */
@Data
public class PanguTicketCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;
    /**
     * 模块类型modelType
     * @see com.bxm.adscounter.facade.mt.PanguMt#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * 竞价id
     */
    @ValidateNotNull
    private String bidid;
    /**
     * 外部bidid
     */
    private String obidid;
    /**
     * ADX广告券ID
     */
    @ValidateNotNull
    private Long adid;
    /**
     * 广告位ID
     */
    private String tagid;
    /**
     * adx素材id
     */
    private String createid;
    /**
     * 用户IP
     */
    private String ip;
    /**
     * 操作系统
     */
    private String os;
    /**
     * User Agent
     */
    private String ua;
    /**
     * MAC地址
     */
    private String mac;
    /**
     * IEMI信息
     */
    private String imei;
    /**
     * 安卓ID
     */
    private String anid;
    /**
     * 第三方匿名设备识别号（暂时用不上）
     */
    private String oaid;
    /**
     * IDFA信息
     */
    private String idfa;
    /**
     * 出价价格/赢价价格,加密数据,单位:分
     */
    private String win;

    /**
     * 出价价格/赢价价格,单位:分
     * 目前外部无传入值
     */
    private Double price;
    /**
     * 请求日期时间戳(毫秒)
     */
    private Long time;
    /**
     * 用户id
     */
    private String uid;
    /**
     * ADX ID
     */
    private String adxid;
    /**
     * 变现猫id
     */
    private String bxmid;
    /**
     * app包名
     */
    private String bundle;
    /**
     * adx appid
     */
    private String adxappid;
    /**
     * app应用分类
     */
    private String appct;
    /**
     * 广告类型
     * 1-常规广告券
     * 12-活动广告券
     * 13-标准直投广告
     */
    private Integer adct;
    /**
     * CPC广告列表,json字符串<br/>
     * <pre>
     * {
     *     adid: null,
     *     createid: null,
     *     price: null
     * }
     * </pre>
     */
    private String adlist;

}
