package com.bxm.adscounter.facade.model;

import lombok.Data;

import java.io.Serializable;

/**
 * <p> S2S上报信息 </p>
 */
@Data
public class S2sReportDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;
    /**
     * 用户ID
     */
    private String uid;
    /**
     * 请求日期时间戳
     */
    private Long timestamp;
    /**
     * 上报类型
     * 1：发券（曝光）
     * 2：点击
     * 3：下载
     * 4：安装
     * 5：中奖
     */
    private Integer type;
    /**
     * 请求ID
     */
    private String requestid;
    /**
     * 媒体公钥
     */
    private String appkey;
    /**
     * 签名
     */
    private String sign;
    /**
     * 奖品id，中奖情况下需上报
     */
    private String prizeid;
    /**
     * 备注
     */
    private String reason;
}
