package com.bxm.adscounter.facade.model;

import com.bxm.adscounter.facade.mt.Mt;
import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.util.List;

/**
 * <p> countInfo接口参数类 </p>
 */
@Data
public class TicketCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;
    /**
     * 用户IP
     */
    private String ipAddress;

    /**
     * 商家标志
     */
    @ValidateNotNull
    @ValidateLength(min = 32,max = 32)
    private String appkey;

    /**
     * 业务类型
     */
    @ValidateNotNull
    private String business;

    /**
     * 流水号(modelName)
     */
    private String spm;

    /**
     * Andriod IMEI(imei)
     */
    @ValidateImeiOrIdfa
    private String i;

    /**
     * IOS IDFA
     */
    @ValidateImeiOrIdfa
    private String f;

    /**
     * 用户token
     */
    @ValidateNotNull
    private String uid;

    /**
     * 设备类型:1 Android;2 IOS;3 web
     */
    @ValidateNotNull
    @DefaultValue("-1")
    private Integer appos;
    /**
     * 系统版本
     */
    private String apposVersion;
    /**
     * 设备型号：华为 mate 10 pro
     */
    private String devm;

    /**
     * 活动ID
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Long activityid;

    /**
     * 模块类型modelType
     * @see Mt#getOriginal()
     */
    @ValidateNotNull
    @DefaultValue("90")
    private Integer modeltype;

    private List<Integer> modeltypes;

    /**
     * 奖品类型awardType
     */
    private Integer awardtype;

    /**
     * 奖品ID(旧名:ticketId)
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Long preid;

    /**
     * 说明
     */
    private String remark;

    /**
     * 客户端标识:1 微信; 2 支付宝;0 其它
     */
    private String ua;

    /**
     * 弹窗类型：0 活动出券;1 首页弹窗;2 挽留弹窗
     */
    @ValidateNotNull
    @DefaultValue("0")
    private Integer scene;

    /**
     * 是否阿里支付isAli:1 是, 0 否
     */
    private String isali;

    /**
     * 当前点击位置：当前点击X轴
     */
    private String random1;

    /**
     * 当前点击位置：当前点击y轴
     */
    private String random2;

    /**
     * 设置宽高，用于统计
     */
    private String random3;

    /**
     * 弹窗ID
     */
    private String popupId;

    /**
     * 素材ID
     */
    private String assetsId;

    /**
     * 请求Header内容
     */
    private String origin;

    /**
     * 本次点击实际出价
     */
    private Integer offerPrice;

    private String referrer;
    private String userAgent;
    /**
     * 统计的唯一标识：如果billid为null则为uuid
     */
    private String countId;

    /**
     * 签名手否正确
     */
    private String remark3;

    /**
     * 是否直投 1：直投  0或者空：非直投
     */
    private Integer direct;

    /**
     *  预留字段ext
     */
    private String ext;
    /** 当前访问的域名 */
    private String domain;

    /**
     * 广告券类型。1- 常规券、2- 备用券、3- 激励券、4- 券码类
     */
    private Byte ticketType;
    /**
     * 票券类型,0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    private Integer useType;
    /**
     * 票券优惠码
     */
    private String couponsCode;
    /**
     * 请求日期时间戳
     */
    private Long timestamp;
    /**
     * APP包名
     */
    private String pkn;
    /**
     * LBS经度
     */
    private String cx;
    /**
     * LBS维度
     */
    private String cy;
    /**
     * 广告所配置url
     */
    private String adurl;
    /**
     * 浮标素材
     */
    private String fmid;
    /**
     * 运营商
     */
    private String isp;
    /**
     * 数据安装列表
     */
    private String appl;
    /**
     * APP版本
     */
    private String appv;
    /**
     * 硬件序列号
     */
    private String ds;
    /**
     * 观看时长
     */
    private Integer vt;
    /**
     * APP应用名
     */
    private String appn;
    /**
     * 操作系统
     */
    private String os;

    /**
     * 出券模型id
     */
    private String fmModelId;

    /**
     * 挽留页面id
     */
    private String wokeId;

    private String sourceType = "0";


    /**
     * 设备加密后的参数
     * @see #device
     */
    @Deprecated
    private String did;

    /**
     * 加密后的设备信息
     */
    private String device;

    /**
     * 媒体自定义扩展参数
     */
    private String extJson;

    /**
     * 落地页id
     */
    private String landId;
    /**
     * 入口广告id
     * @<code>entranceTicketId</code>
     */
    private Long ea;
    /**
     * 入口素材id
     * @<code>entranceAssetsId</code>
     */
    private Long eb;
    /**
     * adx appid
     * @<code>adxAppId</code>
     */
    private String ec;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
