package com.bxm.adscounter.facade.mt;

/**
 * ADX激活回传<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/3 15:12
 */
public enum AdxCallbackMt {

    /** 不明的 */
    _OTHER(-99, Mt._OTHER),
    /** 激活app */
    _1(1, Mt._108),
    /** 注册账号 */
    _2(2, Mt._109),
    /** 激活账号 */
    _3(3, Mt._110),
    /** 登录账号 */
    _4(4, Mt._111),
    /** 用户付费 */
    _5(5, Mt._112),
    ;

    /**
     * 对外MT
     */
    private int original;
    /**
     * @see Mt
     */
    private Mt mt;

    AdxCallbackMt(int original, Mt mt) {
        this.original = original;
        this.mt = mt;
    }

    public int getOriginal() {
        return original;
    }

    public Mt getMt() {
        return mt;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain AdxCallbackMt#_OTHER _OTHER}
     */
    public static AdxCallbackMt of(Integer original) {
        AdxCallbackMt[] values = values();
        for (AdxCallbackMt value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
