package com.bxm.adscounter.facade.mt;

/**
 * 视频对外埋点类型
 *
 * @author kerry.jiang
 * @date 2019/6/14
 * @since 1.0.0
 */
public enum InspireSspMt {

    /** 不明的 */
    _OTHER(-99, Mt._OTHER),
    /** 曝光 */
    _1(1, Mt._6),
    /** 点击 */
    _2(2, Mt._7),
    /** 开始播放 */
    _3(3, Mt._300),
    /** 播放1/4 */
    _4(4, Mt._301),
    /** 播放2/4 */
    _5(5, Mt._302),
    /** 播放3/4 */
    _6(6, Mt._303),
    /** 播放完成 */
    _7(7, Mt._304),
    ;

    /**
     * 对外MT
     */
    private int original;
    /**
     * @see Mt
     */
    private Mt mt;

    InspireSspMt(int original, Mt mt) {
        this.original = original;
        this.mt = mt;
    }

    public int getOriginal() {
        return original;
    }

    public Mt getMt() {
        return mt;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain InspireSspMt#_OTHER _OTHER}
     */
    public static InspireSspMt of(Integer original) {
        InspireSspMt[] values = InspireSspMt.values();
        for (InspireSspMt value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
