package com.bxm.adscounter.facade.mt;

/**
 * 盘古对外埋点类型<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/18 11:18
 */
public enum PanguMt {

    /** 不明的 */
    _OTHER(-99, Mt._OTHER),
    /** 请求 */
    _1(1, Mt._400),
    /** 响应、暂时不用 */
//    _2(2, Mt.null),
    /** 竞价 */
    _3(3, Mt._401),
    /** 曝光 */
    _4(4, Mt._6),
    /** 点击 */
    _5(5, Mt._7),
    /** 胜出 */
    _6(6, Mt._402),
    /** deeplink开始 */
    _7(7, Mt._10),
    /** deeplink成功 */
    _8(8, Mt._11),
    /** deeplink失败 */
    _9(9, Mt._12),
    ;

    /**
     * 对外MT
     */
    private int original;
    /**
     * @see Mt
     */
    private Mt mt;

    PanguMt(int original, Mt mt) {
        this.original = original;
        this.mt = mt;
    }

    public int getOriginal() {
        return original;
    }

    public Mt getMt() {
        return mt;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain PanguMt#_OTHER _OTHER}
     */
    public static PanguMt of(Integer original) {
        PanguMt[] values = PanguMt.values();
        for (PanguMt value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
