/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.adsmedia;

import com.bxm.adscounter.integration.adsmedia.AdsmediaService;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceUrlVO;
import com.bxm.adsmedia.facade.service.AppEntranceFacadeService;
import com.bxm.warcar.utils.response.ResultModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@EnableFeignClients(value={"com.bxm.adsmedia.facade"})
@Configuration
public class AdsmediaServiceImpl
implements AdsmediaService {
    private static final Logger log = LoggerFactory.getLogger(AdsmediaServiceImpl.class);
    @Autowired
    AppEntranceFacadeService appEntranceFacadeService;

    @Override
    public AppEntranceUrlVO getUrl(String positionId) {
        try {
            ResultModel resultModel = this.appEntranceFacadeService.getUrl(positionId);
            if (resultModel.isSuccessed()) {
                AppEntranceUrlVO appEntranceUrlVO = (AppEntranceUrlVO)resultModel.getReturnValue();
                String nomal = appEntranceUrlVO.getNormal();
                if (StringUtils.isNotBlank((CharSequence)appEntranceUrlVO.getDomain())) {
                    UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)nomal);
                    builder.host(appEntranceUrlVO.getDomain());
                    nomal = builder.build().toString();
                    appEntranceUrlVO.setNormal(nomal);
                }
                return appEntranceUrlVO;
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u83b7\u53d6\u5e7f\u544a\u4f4d\u94fe\u63a5\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5e7f\u544a\u4f4d\u94fe\u63a5\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

