/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.aop;

import com.bxm.adscounter.integration.RtbConversion;
import com.bxm.adscounter.integration.RtbConversionRequest;
import com.bxm.adscounter.integration.RtbConversionResponse;
import com.bxm.adscounter.integration.aop.InvokeInterceptor;
import com.google.common.base.Preconditions;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RtbConversionAspect {
    private static final Logger log = LoggerFactory.getLogger(RtbConversionAspect.class);
    private final InvokeInterceptor consumer;

    public RtbConversionAspect(InvokeInterceptor consumer) {
        Preconditions.checkNotNull((Object)consumer);
        this.consumer = consumer;
    }

    @Pointcut(value="this(com.bxm.adscounter.integration.RtbConversion)")
    public void pointcut() {
    }

    @AfterReturning(value="pointcut()", returning="retuning")
    public void around(JoinPoint point, Object retuning) throws Throwable {
        if (!(retuning instanceof RtbConversionResponse)) {
            return;
        }
        Object[] args = point.getArgs();
        if (args.length == 0) {
            return;
        }
        Object arg = args[0];
        if (!(arg instanceof RtbConversionRequest)) {
            return;
        }
        Object target = point.getTarget();
        if (!(target instanceof RtbConversion)) {
            return;
        }
        RtbConversion conversion = (RtbConversion)target;
        RtbConversionRequest request = (RtbConversionRequest)arg;
        RtbConversionResponse response = (RtbConversionResponse)retuning;
        try {
            this.consumer.intercept(conversion, request, response);
        }
        catch (Exception e) {
            log.error("intercept: ", (Throwable)e);
        }
    }
}

