/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.taobao;

import com.bxm.adscounter.integration.taobao.TaobaoIntegration;
import com.bxm.adscounter.integration.taobao.TaobaoProperties;
import com.bxm.adscounter.integration.taobao.TaobaoRequest;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class TaobaoIntegrationImpl
implements TaobaoIntegration {
    private static final Logger log = LoggerFactory.getLogger(TaobaoIntegrationImpl.class);
    private final HttpClient httpClient;

    public TaobaoIntegrationImpl(TaobaoProperties taobaoProperties) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setMaxConnPerRoute(taobaoProperties.getHttpConcurrentRequest().intValue()).setMaxConnTotal(taobaoProperties.getHttpConcurrentRequest().intValue()).build();
    }

    @Override
    public boolean report(TaobaoRequest request) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        String requestId = request.getRequestId();
        this.put((MultiValueMap<String, String>)param, "requestId", requestId);
        this.put((MultiValueMap<String, String>)param, "action", request.getAction());
        this.put((MultiValueMap<String, String>)param, "taskId", request.getTaskId());
        this.put((MultiValueMap<String, String>)param, "app", request.getApp());
        this.put((MultiValueMap<String, String>)param, "channel", request.getChannel());
        this.put((MultiValueMap<String, String>)param, "adid", request.getAdid());
        this.put((MultiValueMap<String, String>)param, "cid", request.getCid());
        this.put((MultiValueMap<String, String>)param, "adAgent", request.getAdAgent());
        this.put((MultiValueMap<String, String>)param, "imei", request.getImei());
        this.put((MultiValueMap<String, String>)param, "imeiMd5", request.getImeiMd5());
        this.put((MultiValueMap<String, String>)param, "oaid", request.getOaid());
        this.put((MultiValueMap<String, String>)param, "oaidMd5", request.getOaidMd5());
        this.put((MultiValueMap<String, String>)param, "idfa", request.getIdfa());
        this.put((MultiValueMap<String, String>)param, "idfaMd5", request.getIdfaMd5());
        this.put((MultiValueMap<String, String>)param, "callbackUrl", request.getCallbackUrl());
        this.put((MultiValueMap<String, String>)param, "advertisingSpaceId", request.getAdvertisingSpaceId());
        this.put((MultiValueMap<String, String>)param, "timestamp", request.getTimestamp());
        String url = UriComponentsBuilder.fromUriString((String)request.getReportUrl()).replaceQueryParams((MultiValueMap)param).build().toString();
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - taobao reporting: {}", (Object)requestId, (Object)url);
            }
            HttpGet get = new HttpGet(url);
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - response: {}", (Object)requestId, (Object)body);
            }
            return StringUtils.equalsIgnoreCase((String)"\"success\"", (String)body);
        }
        catch (IOException e) {
            log.error("{} - taobao report occur exception: {}", (Object)requestId, (Object)e.getMessage());
            return false;
        }
    }

    private void put(MultiValueMap<String, String> param, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            param.add((Object)name, (Object)value);
        }
    }
}

