package com.bxm.adscounter.model;

import com.bxm.adscounter.facade.model.AntiCheat;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 通用的端点，除效果监控外的所有埋点都使用该端点。
 *
 * @author allen
 * @date 2019/3/8
 * @since 1.0.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GeneralEndpoint extends AbstractEndpoint {

    private static final long serialVersionUID = -6721458464992101143L;

    /**
     * 是否阿里支付isAli:1 是, 0 否
     */
    private String isali;
    /**
     * 广告中奖类型：1- 实物奖品、2- 广告券
     */
    private Integer awardType;
    /**
     * 参与类型：0- 活动出券、1- 首页弹窗、2- 挽留弹窗
     */
    private Integer scene;
    /**
     * 弹窗ID
     */
    private String popupId;
    /**
     * 本次出价（单位：厘）
     */
    private Integer offerPrice;
    /**
     * 是否直投
     */
    private Integer direct;
    private String random3;
    /**
     * 当前访问的域名
     */
    private String domain;

    /**
     * 请求日期时间戳
     */
    private Long timestamp;
    /**
     * 载体APP
     */
    private String pkn;
    /**
     * LBS经度
     */
    private String cx;
    /**
     * LBS纬度
     */
    private String cy;
    /**
     * 广告所配置url
     */
    private String adurl;
    /**
     * 浮标素材
     */
    private String fmid;
    /**
     * 运营商
     */
    private String isp;
    /**
     * 数据安装列表
     */
    private String appl;
    /**
     * APP版本
     */
    private String appv;
    /**
     * 硬件序列号
     */
    private String ds;

}
