package com.bxm.adscounter.model;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * <p> 广告点击数据存到 redis 的对象</p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/8/10
 */
public class TicketClickMsg implements Serializable{
    private static final long serialVersionUID = -7972141305707192286L;

    /**
     * 用户IP
     */
    private String ip;
    /**
     * 用户唯一标识
     */
    private String appKey;
    /**
     * 渠道类型
     */
    private String business;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 券ID preid
     */
    private Long ticketId;
    /**
     * 用户token   uid
     */
    private String token;
    /**
     * 素材ID
     */
    private String assetsId;
    /**
     * 设备类型:1 Android;2 IOS;3 web
     */
    private Integer appOs;
    /**
     * 客户端标识:1 微信; 2 支付宝;0 其它
     */
    private String ua;


    //票券码类类型的票券需要的 start-------》
    /**
     * 票券类型,0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    private Integer useType;
    /**
     * 券码
     */
    private String couponsCode;
    //票券码类类型的票券需要的 end--------》


    public TicketClickMsg(){}

    public TicketClickMsg(String ip, String appKey, String business, Long activityId, Long ticketId, String token, String assetsId, Integer appOs, String ua) {
        this.ip = ip;
        this.appKey = appKey;
        this.business = business;
        this.activityId = activityId;
        this.ticketId = ticketId;
        this.token = token;
        this.assetsId = assetsId;
        this.appOs = appOs;
        this.ua = ua;
    }

    public TicketClickMsg(String ip, String appKey, String business, Long activityId, Long ticketId, String token,
                          String assetsId, Integer appOs, String ua, Integer useType, String couponsCode) {
        this.ip = ip;
        this.appKey = appKey;
        this.business = business;
        this.activityId = activityId;
        this.ticketId = ticketId;
        this.token = token;
        this.assetsId = assetsId;
        this.appOs = appOs;
        this.ua = ua;
        this.useType = useType;
        this.couponsCode = couponsCode;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAssetsId() {
        return assetsId;
    }

    public void setAssetsId(String assetsId) {
        this.assetsId = assetsId;
    }

    public Integer getAppOs() {
        return appOs;
    }

    public void setAppOs(Integer appOs) {
        this.appOs = appOs;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public String getCouponsCode() {
        return couponsCode;
    }

    public void setCouponsCode(String couponsCode) {
        this.couponsCode = couponsCode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
