package com.bxm.adscounter.model.constant;

/**
 * <p> 广告券统计数据中的常量 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/25
 */
public class TicketCounterConstant {
    /**
     * 模块类型:
     *     1 JS/API 对接展示
     *     2 JS/API 对接点击
     *     3 活动首页展示
     *     4 活动参与
     *     5 发券请求
     *     6 券曝光
     *     7 券点击
     *     9 中间页展示
     *     10 码券曝光
     */
    public static final int MODEL_TYPE_ONE = 1;
    public static final int MODEL_TYPE_TWO = 2;
    public static final int MODEL_TYPE_THREE= 3;
    public static final int MODEL_TYPE_FOUR = 4;
    public static final int MODEL_TYPE_FIVE = 5;
    public static final int MODEL_TYPE_SIX = 6;
    public static final int MODEL_TYPE_SEVEN = 7;
    public static final int MODEL_TYPE_NINE = 9;
    public static final int MODEL_TYPE_DEFAULT = 90;
    public static final int MODEL_TYPE_100 = 100;

    /**
     * 奖品类型：
     * 1 活动真实奖品
     * 2 礼券
     */
    public static final int AWARD_TYPE_REAL = 1;
    public static final int AWARD_TYPE_TICKET = 2;

    /**
     * 签名是否正确
     */
    public static final String SIGNATURE_IS_OK = "1";
    public static final String SIGNATURE_NOT_OK = "0";

    /**
     * 弹窗类型：0 活动出券;1 首页弹窗;2 挽留弹窗
     */
    public static final int SCENE_TYPE_TICKET = 0;
    public static final int SCENE_TYPE_INDEX = 1;
    public static final int SCENE_TYPE_STAY = 2;

    public static enum SceneType{
        SCENE_TYPE_HDCQ(TicketCounterConstant.SCENE_TYPE_TICKET,"TICKET"),
        SCENE_TYPE_SYTC(TicketCounterConstant.SCENE_TYPE_INDEX,"INDEX"),
        SCENE_TYPE_WLTC(TicketCounterConstant.SCENE_TYPE_STAY,"STAY");

        final int type;
        final String value;

        private SceneType(int type,String value){
            this.type = type;
            this.value = value;
        }

        public static String getValue(int type){
            for(SceneType scene : SceneType.values()){
                if(type == scene.type){
                    return scene.value;
                }
            }
            return "";
        }

    }

}
