package com.bxm.adscounter.model.constant;

/**
 * <p> 统计记录到redis上的常量值 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/25
 */
public class TicketRedisKeyConstant {
    /**
     * 签名密钥
     */
    public final static String  SECRET = "684d2590b5fd4534a44224d419cc4cec";

    /**
     * url链接失效时间:1分钟（毫秒）
     */
    public final static int URL_OUT_TIME = 60 * 1000;
    /**
     * 点击时价格失效时间1天(秒)
     */
    public final static int CLICN_PRICE_OUT_TIME = 24 * 60 * 60;
    /**
     * 点击数据key的开始部分
     */
    public final static String CLICK_HEAD = "clickMsg";
    /**
     * 点击数据key的开始部分--保存到新的redis的key
     */
    public final static String CLICK_HEAD_NEW = "AD:COUNTER:CLICK:BXMID";
    /**
     * 点击数据保存redis的数据库
     */
    public final static int CLICK_DB_INDEX = 11;
    /**
     * 点击数据保存redis有效时间:48 小时
     * 2019-06-14调整为:72 小时
     */
    public final static int CLICK_EXPIRE = 60 * 60*72;
    /**
     * 统计数据保存到reids的数据库
     */
    public final static int COUNTER_DB_INDEX = 3;
    /**
     * 点击时价格存到redis的数据库
     */
    public final static int CLICN_PRICE_DB_INDEX = 0;
    /**
     * 广告券首页展示次数统计 redis 的数据库
     */
    public final static int INDEX_DB_INDEX = 15;
    /**
     * 广告券首页展示次数统计保留三天
     */
    public final static int INDEX_EXPIRE = 60 * 60 * 24 * 3;
    /**
     * 对接效果监控的广告主id
     * */
    public final static String ADVERTISER_SEND_ID = "ADVERTISER:ADSHOP_SEND";
}
