package com.bxm.adscounter.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 通用的端点，除效果监控外的所有埋点都使用该端点。
 *
 * @author allen
 * @date 2019/3/8
 * @since 1.0.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GeneralEndpoint extends AbstractEndpoint {

    private static final long serialVersionUID = -6721458464992101143L;

    /**
     * 是否阿里支付isAli:1 是, 0 否
     */
    private String isali;
    /**
     * 广告中奖类型：1- 实物奖品、2- 广告券
     */
    private Integer awardType;
    /**
     * 参与类型：0- 活动出券、1- 首页弹窗、2- 挽留弹窗
     */
    private Integer scene;
    /**
     * 弹窗ID
     */
    private String popupId;
    /**
     * 本次出价（单位：厘）
     */
    private Integer offerPrice;
    /**
     * 本次出价（单位：厘, 高精度）
     */
    private Double offerPricePrecision;
    /**
     * 是否直投
     */
    private Integer direct;
    private String random3;
    /**
     * 当前访问的域名
     */
    private String domain;

    /**
     * 请求日期时间戳
     */
    private Long timestamp;
    /**
     * 载体APP包名
     */
    private String packageName;
    /**
     * LBS经度
     */
    private String longitude;
    /**
     * LBS纬度
     */
    private String latitude;
    /**
     * 广告所配置url
     */
    private String adurl;
    /**
     * 浮标素材
     */
    private String fmid;
    /**
     * 运营商
     */
    private String isp;
    /**
     * 数据安装列表
     */
    private String appl;
    /**
     * APP版本
     */
    private String appv;
    /**
     * 硬件序列号
     */
    private String ds;
    /**
     * 广告位
     */
    private String position;
    /**
     * 操作系统
     */
    private String osName;
    /**
     * 联网方式,0:未知, 1:wifi, 2:数据网络-未知, 3:2G, 4:3G, 5:4G, 6:5G
     */
    private String netType;
    /**
     * 用户性别
     */
    private String gender;
    /**
     * 出生年份
     */
    private String birthYear;
    /**
     * 用户标签
     */
    private String userLabel;
    /**
     * 定位类型
     */
    private String geoType;
    /**
     * 应用id
     */
    private String appId;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 应用类型
     */
    private String appCategory;
    /**
     * 素材地址
     */
    private String assetsUrl;

    //Inspire
    /**
     * 观看时长
     */
    private Integer view_time;
    //Inspire END

    /**
     * fm出券模型id
     */
    private String fmModelId;

    /**
     * 挽留页面id
     */
    private String wokeId;

    private String sourceType = "0";

    /**
     * ADX ID
     */
    private String adxid;


    /**
     * imei
     */
    private String imei;
    /**
     * imei md5
     */
    private String imeiMd5;
    /**
     * 安卓id
     */
    private String anid;
    /**
     * 安卓id md5
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * oaid md5
     */
    private String oaidMd5;
    /**
     * idfa
     */
    private String idfa;
    /**
     * idfa md5
     */
    private String idfaMd5;

    /**
     * 落地页id
     */
    private String landId;
    /**
     * 扩展信息(用户特征)
     */
    private String extinfo;

    /**
     * 用户当天请求次数
     */
    private Integer userReqNum;

    /**
     * CPC广告列表,json字符串<br/>
     * <pre>
     * {
     *     adid: null,
     *     createid: null,
     *     price: null
     * }
     * </pre>
     */
    private String adlist;
    /**
     * RTA广告请求参数
     */
    private String rta_ptce;
    /**
     * RTA是否命中（0 未命中、1 命中）
     */
    private String rta_hit;
    /**
     * RTA是否请求成功（0 失败、1 成功）
     */
    private String rta_status;
    /**
     * appid(SSP)
     */
    private String sspAppId;
    /**
     * 广告位id(SSP)
     */
    private String sspPositionId;
    /**
     * 算法标签信息
     */
    private String algorithmTag;

    /**
     * ocpa的cpa出价
     */
    private Integer ocpaOfferPrice;
    /**
     * ocpa的配置转化目标
     */
    private Short targetConvType;
    /**
     * 券类型 1cpc 2cpa  3ocpc  4 cpm 5 ocpa
     */
    private Byte settleType;

    /**
     * 活动流量分配计划id
     */
    private String activityTestPlanId;

    /**
     * 盘古素材库ids ex: 1,2,3
     */
    private String picId;


    /**
     * 盘古直投扣除广告主的价格
     */
    private String adverCost;

    /**
     * 发券次序
     */
    private String seq;

}
