package com.bxm.adscounter.model.constant;


import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * <h3>广告券相关KEY创建者</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/12
 */
public final class RedisKeyGenerator {


    /**
     * AD:COUNTER:DAILY_BUDGET:FAST:${yyyyMMdd}
     */
    public static KeyGenerator getFastDailyBudget( ){
        return () -> KeyBuilder.build("AD","COUNTER", "DAILY_BUDGET"  , "FAST", DateHelper.format("yyyyMMdd"));
    }


    public static KeyGenerator getCurrentADXUserTicket(String uid, String ticketId) {
        return () -> KeyBuilder.build("ADX", "COUNTER", "CURRENT", uid, ticketId);
    }

    /**
     * 盘古埋点排重
     * @param adxid adxid
     * @param bidid bidid
     * @param mt 外部埋点值
     * @return
     */
    public static KeyGenerator getPanGuRepeatMt(String adxid, String bidid, Integer mt) {
        return () -> KeyBuilder.build("PANGU", "REPEAT", "MT", adxid, bidid, mt);
    }

    @Deprecated
    public static KeyGenerator activityJoin(String uid) {
        return () -> KeyBuilder.build("ACTIVITY","JOIN", "COUNT",uid);
    }

    public static KeyGenerator hashOverseasClickIdKey(String cashcatClickId) {
        return () -> KeyBuilder.build("overseas", "click", cashcatClickId);
    }

    public static KeyGenerator hashEventNameMappingKey() {
        return () -> KeyBuilder.build("overseas", "event_name_mapping");
    }

    public static KeyGenerator hashOverseasConfigKey() {
        return () -> KeyBuilder.build("overseas", "feedback_config");
    }

    public static KeyGenerator strConversionValid(String bxmid) {
        return () -> KeyBuilder.build("conversion", "valid", bxmid);
    }

    /**
     * 创建七猫设备号与click_id的存储 Key
     * @param deviceId 设备号
     * @return KeyGenerator
     */
    public static KeyGenerator strQiMaoDeviceClickId(String deviceId) {
        return () -> KeyBuilder.build("rtb", "qimao", "device_click_id", deviceId);
    }

    /**
     * 创建支付宝灯火 ip与click_id的存储 Key
     * @param ip
     * @return KeyGenerator
     */
    public static KeyGenerator strAlipaydhIpClickId(String ip) {
        return () -> KeyBuilder.build("rtb", "alipdh", "ip_click_id", ip);
    }

    /**
     * 创建新浪ip与click_id的存储 Key
     * @param ipUa
     * @return KeyGenerator
     */
    public static KeyGenerator strSinaIpUaClickId(String ipUa) {
        return () -> KeyBuilder.build("rtb", "sina", "ip_ua_click_id", ipUa);
    }

    /**
     * 已回传的clickId
     *
     * @param positionId
     * @param clickId
     * @return
     */
    public static KeyGenerator strFeedbackClickId(String positionId, String clickId) {
        return () -> KeyBuilder.build("rtb_control", "click_id", positionId, clickId);
    }
}
