package com.bxm.adscounter.model.msgqueue;

import com.bxm.adscounter.model.EffectEndpoint;
import org.apache.commons.lang.math.NumberUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 发送到MQ中的统计信息对象（old）
 */
public class CountCertifiateAdshop implements Serializable {
    private Long id;

    private String ipaddress;

    private String phone;

    private String adshopcode;

    private Integer status;

    private String idcardnum;

    private String shotCountid;

    private Long shotActivityid;

    private Long shotCertificateid;

    private String shotAppkey;

    private String shotIpaddress;

    private String shotBusiness;

    private Date created;

    private String param;
    
    private String shotToken;
    
    private String modeltype;
    
    private String assetsId;
    
    private Integer appos;
    
    private String ua;

    public CountCertifiateAdshop(EffectEndpoint endpoint) {
        this.shotIpaddress = endpoint.getIp();
        this.shotAppkey = endpoint.getAppKey();
        this.shotBusiness = endpoint.getBusiness();
        this.shotActivityid = endpoint.getActivityId();
        this.shotCertificateid = endpoint.getTicketId();
        this.shotToken = endpoint.getUid();
        this.modeltype = String.valueOf(endpoint.getMt());
        this.shotCountid = endpoint.getOrderId();
        this.adshopcode = endpoint.getShopCode();
        this.created = new Date();
        this.status = NumberUtils.toInt(endpoint.getStatus(), 2);
        this.ipaddress = endpoint.getIp();
        this.param = endpoint.getParam();
        this.phone = endpoint.getPhone();
        this.idcardnum = endpoint.getIdCardNum();
        this.assetsId = endpoint.getAssetsId();
        this.appos = endpoint.getAppos();
        this.ua = endpoint.getApp();
    }

    public String getModeltype() {
		return modeltype;
	}

	public void setModeltype(String modeltype) {
		this.modeltype = modeltype;
	}

	public String getShotToken() {
		return shotToken;
	}

	
    /**
     * @return the assetsId
     */
    public String getAssetsId() {
        return assetsId;
    }

    
    /**
     * @param assetsId the assetsId to set
     */
    public void setAssetsId(String assetsId) {
        this.assetsId = assetsId;
    }

    public void setShotToken(String shotToken) {
		this.shotToken = shotToken;
	}

	private static final long serialVersionUID = 1L;
    
	public CountCertifiateAdshop(String ipaddress, String phone, String adshopcode, Integer status, String idcardnum,
                                 String shotCountid, String param, String modeltype) {
		super();
		this.ipaddress = ipaddress;
		this.phone = phone;
		this.adshopcode = adshopcode;
		this.status = status;
		this.idcardnum = idcardnum;
		this.shotCountid = shotCountid;
		this.param = param;
		this.modeltype = modeltype;
	}
	
	public String getShotBusiness() {
		return shotBusiness;
	}



	public void setShotBusiness(String shotBusiness) {
		this.shotBusiness = shotBusiness;
	}

	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress == null ? null : ipaddress.trim();
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone == null ? null : phone.trim();
    }

    public String getAdshopcode() {
        return adshopcode;
    }

    public void setAdshopcode(String adshopcode) {
        this.adshopcode = adshopcode == null ? null : adshopcode.trim();
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getIdcardnum() {
        return idcardnum;
    }

    public void setIdcardnum(String idcardnum) {
        this.idcardnum = idcardnum == null ? null : idcardnum.trim();
    }

    public String getShotCountid() {
        return shotCountid;
    }

    public void setShotCountid(String shotCountid) {
        this.shotCountid = shotCountid;
    }

    public Long getShotActivityid() {
        return shotActivityid;
    }

    public void setShotActivityid(Long shotActivityid) {
        this.shotActivityid = shotActivityid;
    }

    public Long getShotCertificateid() {
        return shotCertificateid;
    }

    public void setShotCertificateid(Long shotCertificateid) {
        this.shotCertificateid = shotCertificateid;
    }

    public String getShotAppkey() {
        return shotAppkey;
    }

    public void setShotAppkey(String shotAppkey) {
        this.shotAppkey = shotAppkey == null ? null : shotAppkey.trim();
    }

    public String getShotIpaddress() {
        return shotIpaddress;
    }

    public void setShotIpaddress(String shotIpaddress) {
        this.shotIpaddress = shotIpaddress == null ? null : shotIpaddress.trim();
    }

    public Date getCreated() {
        return created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getParam() {
        return param;
    }

    public void setParam(String param) {
        this.param = param == null ? null : param.trim();
    }

    public Integer getAppos() {
		return appos;
	}

	public void setAppos(Integer appos) {
		this.appos = appos;
	}

	public String getUa() {
		return ua;
	}

	public void setUa(String ua) {
		this.ua = ua;
	}

	public CountCertifiateAdshop(CountCertifiateAdshop record, String[] msgs) {
        this.shotIpaddress = msgs[0];
        this.shotAppkey = msgs[1];
        this.shotBusiness = msgs[2];
        this.shotActivityid = NumberUtils.isNumber(msgs[3])?Long.valueOf(msgs[3]):0;
        this.shotCertificateid = NumberUtils.isNumber(msgs[4])?Long.valueOf(msgs[4]):0;
        this.shotToken = msgs[5];
        this.modeltype = record.getModeltype();
        this.shotCountid = record.getShotCountid();
        this.adshopcode = record.getAdshopcode();
        this.created = new Date();
        this.status = record.getStatus();
        this.ipaddress = record.getIpaddress();
        this.param = record.getParam();
        this.phone = record.getPhone();
        this.idcardnum = record.getIdcardnum();
        if (msgs.length > 6) {
            this.assetsId = msgs[6];
        }
        if (msgs.length > 7) {
        	this.appos = Integer.valueOf(msgs[7]);
        }
        if (msgs.length > 8) {
        	this.ua = msgs[8];
        }
    }

    public CountCertifiateAdshop(){
        super();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        CountCertifiateAdshop other = (CountCertifiateAdshop) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getIpaddress() == null ? other.getIpaddress() == null : this.getIpaddress().equals(other.getIpaddress()))
            && (this.getPhone() == null ? other.getPhone() == null : this.getPhone().equals(other.getPhone()))
            && (this.getAdshopcode() == null ? other.getAdshopcode() == null : this.getAdshopcode().equals(other.getAdshopcode()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getIdcardnum() == null ? other.getIdcardnum() == null : this.getIdcardnum().equals(other.getIdcardnum()))
            && (this.getShotCountid() == null ? other.getShotCountid() == null : this.getShotCountid().equals(other.getShotCountid()))
            && (this.getShotActivityid() == null ? other.getShotActivityid() == null : this.getShotActivityid().equals(other.getShotActivityid()))
            && (this.getShotCertificateid() == null ? other.getShotCertificateid() == null : this.getShotCertificateid().equals(other.getShotCertificateid()))
            && (this.getShotAppkey() == null ? other.getShotAppkey() == null : this.getShotAppkey().equals(other.getShotAppkey()))
            && (this.getShotIpaddress() == null ? other.getShotIpaddress() == null : this.getShotIpaddress().equals(other.getShotIpaddress()))
            && (this.getCreated() == null ? other.getCreated() == null : this.getCreated().equals(other.getCreated()))
            && (this.getParam() == null ? other.getParam() == null : this.getParam().equals(other.getParam()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getIpaddress() == null) ? 0 : getIpaddress().hashCode());
        result = prime * result + ((getPhone() == null) ? 0 : getPhone().hashCode());
        result = prime * result + ((getAdshopcode() == null) ? 0 : getAdshopcode().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getIdcardnum() == null) ? 0 : getIdcardnum().hashCode());
        result = prime * result + ((getShotCountid() == null) ? 0 : getShotCountid().hashCode());
        result = prime * result + ((getShotActivityid() == null) ? 0 : getShotActivityid().hashCode());
        result = prime * result + ((getShotCertificateid() == null) ? 0 : getShotCertificateid().hashCode());
        result = prime * result + ((getShotAppkey() == null) ? 0 : getShotAppkey().hashCode());
        result = prime * result + ((getShotIpaddress() == null) ? 0 : getShotIpaddress().hashCode());
        result = prime * result + ((getCreated() == null) ? 0 : getCreated().hashCode());
        result = prime * result + ((getParam() == null) ? 0 : getParam().hashCode());
        return result;
    }
}