package com.bxm.adscounter.model;

import java.io.Serializable;
import java.math.BigInteger;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * <p> 广告点击数据存到 redis 的对象</p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/8/10
 */
public class TicketClickMsg implements Serializable{
    private static final long serialVersionUID = -7972141305707192286L;

    /**
     * 用户IP
     */
    private String ip;
    /**
     * 媒体公钥appKey
     */
    private String appKey;
    /**
     * 渠道类型
     */
    private String business;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 券ID preid
     */
    private Long ticketId;
    /**
     * 用户token   uid
     */
    private String token;
    /**
     * 素材ID
     */
    private String assetsId;
    /**
     * 设备类型:1 Android;2 IOS;3 web
     */
    private Integer appOs;
    /**
     * 客户端标识:1 微信; 2 支付宝;0 其它
     */
    private String ua;


    //票券码类类型的票券需要的 start-------》
    /**
     * 票券类型,0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    private Integer useType;
    /**
     * 券码
     */
    private String couponsCode;
    //票券码类类型的票券需要的 end--------》

    /**
     * 媒体扩展参数
     */
    private String extJson;

    /**
     * 落地页id
     */
    private String landId;
    /**
     * 入口广告id
     */
    private Long entrTicketId;
    /**
     * 入口素材id
     */
    private Long entrAssetsId;

    /**
     * Bid id
     */
    private String bidid;
    /**
     * Outer bid id
     */
    private String obidid;
    /**
     * Adx app id
     */
    private String adxAppId;
    /**
     * referrer
     */
    private String referrer;

    /**
     * User-Agent
     */
    private String userAgent;

    /**
     * ocpa的cpa出价
     */
    private Integer ocpaOfferPrice;
    /**
     * ocpa的配置转化目标
     */
    private Short targetConvType;
    /**
     * 券类型 1cpc 2cpa  3ocpc  4 cpm 5 ocpa
     */
    private Byte settleType;

    public TicketClickMsg(){}

    public TicketClickMsg(String ip, String appKey, String business, Long activityId, Long ticketId, String token, String assetsId, Integer appOs, String ua) {
        this.ip = ip;
        this.appKey = appKey;
        this.business = business;
        this.activityId = activityId;
        this.ticketId = ticketId;
        this.token = token;
        this.assetsId = assetsId;
        this.appOs = appOs;
        this.ua = ua;
    }

    public TicketClickMsg(String ip, String appKey, String business, Long activityId, Long ticketId, String token,
                          String assetsId, Integer appOs, String ua, Integer useType, String couponsCode, String extJson) {
        this.ip = ip;
        this.appKey = appKey;
        this.business = business;
        this.activityId = activityId;
        this.ticketId = ticketId;
        this.token = token;
        this.assetsId = assetsId;
        this.appOs = appOs;
        this.ua = ua;
        this.useType = useType;
        this.couponsCode = couponsCode;
        this.extJson = extJson;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAssetsId() {
        return assetsId;
    }

    public void setAssetsId(String assetsId) {
        this.assetsId = assetsId;
    }

    public Integer getAppOs() {
        return appOs;
    }

    public void setAppOs(Integer appOs) {
        this.appOs = appOs;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public String getCouponsCode() {
        return couponsCode;
    }

    public void setCouponsCode(String couponsCode) {
        this.couponsCode = couponsCode;
    }

    public String getLandId() {
        return landId;
    }

    public void setLandId(String landId) {
        this.landId = landId;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }

    public Long getEntrTicketId() {
        return entrTicketId;
    }

    public void setEntrTicketId(Long entrTicketId) {
        this.entrTicketId = entrTicketId;
    }

    public Long getEntrAssetsId() {
        return entrAssetsId;
    }

    public void setEntrAssetsId(Long entrAssetsId) {
        this.entrAssetsId = entrAssetsId;
    }

    public String getBidid() {
        return bidid;
    }

    public void setBidid(String bidid) {
        this.bidid = bidid;
    }

    public String getObidid() {
        return obidid;
    }

    public void setObidid(String obidid) {
        this.obidid = obidid;
    }

    public String getAdxAppId() {
        return adxAppId;
    }

    public void setAdxAppId(String adxAppId) {
        this.adxAppId = adxAppId;
    }

    public String getReferrer() {
        return referrer;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public Integer getOcpaOfferPrice() {
        return ocpaOfferPrice;
    }

    public void setOcpaOfferPrice(Integer ocpaOfferPrice) {
        this.ocpaOfferPrice = ocpaOfferPrice;
    }

    public Short getTargetConvType() {
        return targetConvType;
    }

    public void setTargetConvType(Short targetConvType) {
        this.targetConvType = targetConvType;
    }

    public Byte getSettleType() {
        return settleType;
    }

    public void setSettleType(Byte settleType) {
        this.settleType = settleType;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
