package com.bxm.adscounter.model.overseas;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tangxiao
 * @date 2023-02-21
 * @since 1.0
 */
@Data
public class OverseasAdvertMediaConfig implements Serializable {
    private Long id;

    /**
     * 关联海外预算广告id
     */
    private Long advertId;

    /**
     * 投放对象 1.联盟开户 2.外投代理
     */
    private Byte putTarget;

    /**
     * 开户渠道 如：Mintegral
     */
    private String media;

    /**
     * 开户渠道id
     */
    private String mediaChannel;

    /**
     * 投放方式 1.中间页 2.直投
     */
    private Byte putType;

    /**
     * 追踪链接
     */
    private String trackingLink;

    /**
     * 渠道监测事件
     */
    private String targetType;

    /**
     * 产品回传目标
     */
    private String sourceType;

    /**
     * 产品回传目标与渠道监测事件的映射关系
     */
    private String sourceTargetMapping;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 编辑时间
     */
    private Date updateTime;

    /**
     * 编辑人
     */
    private String updateUser;

    /**
     * 是否删除  0.否 1.是
     */
    private Byte deleted;

    private static final long serialVersionUID = 1L;
}