package com.bxm.adscounter.model.overseas;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author tangxiao
 * @date 2023/2/22
 * @since 1.0
 */
@AllArgsConstructor
@Getter
public enum OverseasMedia {

    Mintegral("1"),

    Bigo("2")

    ;

    private String siteId;

    public static boolean contains(String siteId) {
        if (StringUtils.isBlank(siteId)) {
            return false;
        }

        for (OverseasMedia overseasMedia : OverseasMedia.values()) {
            if (Objects.equals(overseasMedia.getSiteId(), siteId)) {
                return true;
            }
        }
        return false;
    }
}
