/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.GroupAttribute;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class MachineGroup
implements Serializable {
    private static final long serialVersionUID = -4402651900796187066L;
    protected String groupName = "";
    protected String groupType = "";
    protected String machineIdentifyType = "";
    protected GroupAttribute groupAttribute = new GroupAttribute();
    protected ArrayList<String> machineList = new ArrayList();
    protected int createTime = 0;
    protected int lastModifyTime = 0;

    public MachineGroup() {
    }

    public MachineGroup(String groupName, String machineIdentifyType, ArrayList<String> machineList) {
        this.groupName = groupName;
        this.machineIdentifyType = machineIdentifyType;
        this.SetMachineList(machineList);
    }

    public MachineGroup(MachineGroup machineGroup) {
        this.groupName = machineGroup.GetGroupName();
        this.groupType = machineGroup.GetGroupType();
        this.machineIdentifyType = machineGroup.GetMachineIdentifyType();
        this.SetGroupAttribute(machineGroup.GetGroupAttribute());
        this.SetMachineList(machineGroup.GetMachineList());
        this.createTime = machineGroup.GetCreateTime();
        this.lastModifyTime = machineGroup.GetLastModifyTime();
    }

    public String GetGroupName() {
        return this.groupName;
    }

    public void SetGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String GetGroupType() {
        return this.groupType;
    }

    public void SetGroupType(String groupType) {
        this.groupType = groupType;
    }

    public GroupAttribute GetGroupAttribute() {
        return this.groupAttribute;
    }

    public void SetGroupAttribute(GroupAttribute groupAttribute) {
        this.groupAttribute = new GroupAttribute(groupAttribute);
    }

    public String GetMachineIdentifyType() {
        return this.machineIdentifyType;
    }

    public void SetMachineIdentifyType(String machineIdentifyType) {
        this.machineIdentifyType = machineIdentifyType;
    }

    public ArrayList<String> GetMachineList() {
        return this.machineList;
    }

    public void SetMachineList(ArrayList<String> machineList) {
        this.machineList = new ArrayList();
        for (String machine : machineList) {
            this.machineList.add(machine);
        }
    }

    public void SetMachineList(JSONArray machineListJSONArray) {
        this.machineList = new ArrayList();
        for (int i = 0; i < machineListJSONArray.size(); ++i) {
            String machine = machineListJSONArray.getString(i);
            this.machineList.add(machine);
        }
    }

    public int GetCreateTime() {
        return this.createTime;
    }

    public void SetCreateTime(int createTime) {
        this.createTime = createTime;
    }

    public int GetLastModifyTime() {
        return this.lastModifyTime;
    }

    public void SetLastModifyTime(int lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public String GetExternalName() {
        return this.groupAttribute.GetExternalName();
    }

    public void SetExternalName(String externalName) {
        this.groupAttribute.SetExternalName(externalName);
    }

    public String GetGroupTopic() {
        return this.groupAttribute.GetGroupTopic();
    }

    public void SetGroupTopic(String groupTopic) {
        this.groupAttribute.SetGroupTopic(groupTopic);
    }

    private JSONObject ToRequestJson() {
        JSONObject groupDict = new JSONObject();
        groupDict.put((Object)"groupName", (Object)this.GetGroupName());
        groupDict.put((Object)"groupType", (Object)this.GetGroupType());
        groupDict.put((Object)"machineIdentifyType", (Object)this.GetMachineIdentifyType());
        groupDict.put((Object)"groupAttribute", (Object)this.GetGroupAttribute().ToJsonString());
        JSONArray machineList = new JSONArray();
        for (String machine : this.GetMachineList()) {
            machineList.add((Object)machine);
        }
        groupDict.put((Object)"machineList", (Object)machineList);
        return groupDict;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        JSONObject groupDict = this.ToRequestJson();
        JSONArray machineList = new JSONArray();
        for (String machine : this.GetMachineList()) {
            machineList.add((Object)machine);
        }
        groupDict.put((Object)"machineList", (Object)machineList);
        groupDict.put((Object)"createTime", (Object)this.GetCreateTime());
        groupDict.put((Object)"lastModifyTime", (Object)this.GetLastModifyTime());
        return groupDict;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            String groupName = dict.getString("groupName");
            String machineIdentifyType = dict.getString("machineIdentifyType");
            JSONArray machineList = dict.getJSONArray("machineList");
            this.SetGroupName(groupName);
            this.SetMachineIdentifyType(machineIdentifyType);
            this.SetMachineList(machineList);
            if (dict.containsKey((Object)"groupType")) {
                this.SetGroupType(dict.getString("groupType"));
            }
            if (dict.containsKey((Object)"groupAttribute")) {
                JSONObject groupAttributeString = dict.getJSONObject("groupAttribute");
                GroupAttribute groupAttribute = new GroupAttribute();
                groupAttribute.FromJsonObject(groupAttributeString);
                this.SetGroupAttribute(groupAttribute);
            }
            if (dict.containsKey((Object)"createTime")) {
                this.SetCreateTime(dict.getInt("createTime"));
            }
            if (dict.containsKey((Object)"lastModifyTime")) {
                this.SetLastModifyTime(dict.getInt("lastModifyTime"));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachineGroup", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String machineGroupString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)machineGroupString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachineGroup", e.getMessage(), e, "");
        }
    }
}

