/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.gttyc;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.gttyc.GttycRequest;
import com.bxm.pangu.rta.common.gttyc.GttycResponse;
import com.bxm.pangu.rta.common.gttyc.GttycRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UUIDHelper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class GttycRtaClient
extends AbstractHttpClientRtaClient {
    private final GttycRtaProperties properties;

    public GttycRtaClient(GttycRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        if (StringUtils.isBlank((String)request.getOaid_md5())) {
            throw new RtaRequestException("The oaid_md5 cannot be empty");
        }
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("param");
        }
        String[] arr = StringUtils.splitPreserveAllTokens((String)param, (String)"|");
        if (arr.length < 4) {
            throw new RtaRequestException("param must be {accessId}|{accessSecrectKey}|{deviceType}|{projectTaskList}");
        }
        String accessId = arr[0];
        String accessSecrectKey = arr[1];
        String deviceType = arr[2];
        String projectTaskList = arr[3];
        HttpPost post = new HttpPost(this.properties.getUrl() + accessId);
        String timeStamp = TypeHelper.castToString((Object)System.currentTimeMillis());
        post.addHeader("timeStamp", timeStamp);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.addHeader("token", DigestUtils.md5Hex((String)(accessId + accessSecrectKey + timeStamp)));
        GttycRequest gttycRequest = new GttycRequest();
        gttycRequest.setRequestId(UUIDHelper.generate());
        gttycRequest.setDeviceType(deviceType);
        gttycRequest.setDeviceId(request.getOaid_md5());
        JSONObject jsonObject = JSONObject.parseObject((String)projectTaskList);
        gttycRequest.setProjectTaskList(jsonObject);
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)gttycRequest), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        GttycResponse response = (GttycResponse)JsonHelper.convert((String)json, GttycResponse.class);
        if (!response.isRequestOk()) {
            return false;
        }
        Map<String, String[]> data = response.getData();
        return MapUtils.isNotEmpty(data);
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Gttyc;
    }
}

