/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.autoconfigure;

import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.bxm.adscounter.ocpx.common.SlsProperties;
import com.bxm.warcar.logging.extension.AliyunLogServiceCustomLoggingWriter;
import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SlsProperties.class})
public class ReportingAutoConfiguration {
    private final SlsProperties properties;

    public ReportingAutoConfiguration(SlsProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"customLoggingWriterForOcpxClickReporting"})
    public CustomLoggingWriter customLoggingWriterForOcpxClickReporting() {
        return this.createCustomLoggingWriter(this.properties.getLogStoreForOcpxClickReporting());
    }

    private CustomLoggingWriter createCustomLoggingWriter(String logStore) {
        ProducerConfig producerConfig = new ProducerConfig();
        ProjectConfig projectConfig = new ProjectConfig(this.properties.getProject(), this.properties.getEndpoint(), this.properties.getAccessKeyId(), this.properties.getAccessKeySecret());
        AliyunLogServiceCustomLoggingWriter writer = new AliyunLogServiceCustomLoggingWriter(producerConfig, projectConfig, logStore);
        if (this.properties.isEnableThreadPool()) {
            int coreSize = this.properties.getCoreSize();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(500), (ThreadFactory)new NamedThreadFactory("sls-writer"));
            writer.setExecutor(executor);
        }
        return writer;
    }
}

