/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.controller;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedbackDispatcher;
import com.bxm.adscounter.ocpx.openlog.event.ConversionFeedbackEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.StringHelper;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alipay"})
public class AlipayController {
    private static final Logger log = LoggerFactory.getLogger(AlipayController.class);
    private final ConversionFeedbackDispatcher dispatcher;

    public AlipayController(ConversionFeedbackDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @GetMapping(value={"/callback"})
    public void alipayCallBack(@RequestParam(value="oaid_md5") String oaidMd5, @RequestParam(value="adid") String adid, @RequestParam(value="trackType") Integer trackType, @RequestParam(value="cid") String cid, @RequestParam(value="channel", required=false) String channel) {
        log.info("alipay request oaidmd5:{} - adid:{} - trackType:{} - cid:{} - channel:{}", new Object[]{oaidMd5, adid, trackType, cid, channel});
        try {
            KeyValueMap clickLog = new KeyValueMap();
            String[] split = adid.split(">");
            String bxmMedia = split[0].trim();
            String convDef = split[1].trim();
            clickLog.putIfNotBlank("bxmmedia", bxmMedia);
            clickLog.putIfNotBlank("bxmadvertiser", RtbAdvertiser.Alipay.getType());
            clickLog.putIfNotBlank("conv_def", convDef);
            clickLog.putIfNotBlank("click_id", this.getClickId(bxmMedia, cid));
            clickLog.putIfNotBlank(RtbAdvertiser.Alipay.getTransferType(), String.valueOf(trackType));
            this.dispatcher.dispatch(new ConversionFeedbackEvent(this, clickLog));
        }
        catch (Exception e) {
            log.error("alipay: ", (Throwable)e);
        }
    }

    private String getClickId(String bxmMedia, String cid) {
        switch (bxmMedia) {
            case "kuaishou": {
                return Base64.encodeBase64URLSafeString((byte[])StringHelper.convert((String)cid));
            }
            case "oceanengine": {
                return cid;
            }
        }
        throw new IllegalArgumentException("bxmMedia not support: " + bxmMedia);
    }
}

