/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.controller;

import com.bxm.adscounter.facade.model.jdong.JdongData;
import com.bxm.adscounter.facade.model.jdong.JdongRequestDTO;
import com.bxm.adscounter.facade.model.jdong.JdongResponseVO;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.constant.OcpxKeyGenerator;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedbackDispatcher;
import com.bxm.adscounter.ocpx.openlog.event.ConversionFeedbackEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jdong"})
public class JdController {
    private static final Logger log = LoggerFactory.getLogger(JdController.class);
    private final JedisFetcher jedisFetcher;
    private final ConversionFeedbackDispatcher dispatcher;

    public JdController(JedisFetcher jedisFetcher, ConversionFeedbackDispatcher dispatcher) {
        this.jedisFetcher = jedisFetcher;
        this.dispatcher = dispatcher;
    }

    @PostMapping(value={"/jdongCallBack"})
    public JdongResponseVO jdCallBack(@RequestBody JdongRequestDTO jdongRequestDTO) {
        log.info("jingdong input param : {}", (Object)jdongRequestDTO);
        try {
            JdongData data = jdongRequestDTO.getData();
            if (Objects.isNull(data)) {
                throw new NullPointerException("data");
            }
            String deviceId = data.getDeviceId();
            KeyValueMap clickLog = (KeyValueMap)this.jedisFetcher.fetch(OcpxKeyGenerator.stringOcpxDeviceCache(deviceId), KeyValueMap.class);
            if (Objects.isNull(clickLog)) {
                throw new NullPointerException("Not found keyValueMap: " + deviceId);
            }
            clickLog.putIfNotBlank(RtbAdvertiser.Jd.getTransferType(), String.valueOf(data.getActionType()));
            this.dispatcher.dispatch(new ConversionFeedbackEvent(this, clickLog));
            return JdongResponseVO.builder().success(Boolean.TRUE).build();
        }
        catch (Exception e) {
            log.error("jd: ", (Throwable)e);
            return JdongResponseVO.builder().success(Boolean.FALSE).build();
        }
    }
}

