/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.constant.OcpxKeyGenerator;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedbackDispatcher;
import com.bxm.adscounter.ocpx.openlog.event.ConversionFeedbackEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/meituan_ocps"})
public class MeituanOcpsController {
    private static final Logger log = LoggerFactory.getLogger(MeituanOcpsController.class);
    private final JedisFetcher jedisFetcher;
    private final ConversionFeedbackDispatcher dispatcher;
    public static final String DEFAULT_EVENT_TYPE = "1";

    public MeituanOcpsController(JedisFetcher jedisFetcher, ConversionFeedbackDispatcher dispatcher) {
        this.jedisFetcher = jedisFetcher;
        this.dispatcher = dispatcher;
    }

    @PostMapping(value={"/callback"})
    public MeituanOcpsResponse callback(@RequestBody MeituanOcpsRequest meituanOcpsRequest) {
        KeyValueMap clickLog;
        try {
            clickLog = this.getClickLog(meituanOcpsRequest);
        }
        catch (NullPointerException e) {
            log.warn("meituan ocps cannot find click by {}", (Object)JSONObject.toJSONString((Object)meituanOcpsRequest));
            return MeituanOcpsResponse.fail(e.getMessage());
        }
        clickLog.put(RtbAdvertiser.MeiTuanOcps.getTransferType(), DEFAULT_EVENT_TYPE);
        clickLog.put("direct", meituanOcpsRequest.getDirect());
        clickLog.put("quantity", meituanOcpsRequest.getQuantity());
        this.dispatcher.dispatch(new ConversionFeedbackEvent(this, clickLog));
        return MeituanOcpsResponse.success();
    }

    private KeyValueMap getClickLog(MeituanOcpsRequest meituanOcpsRequest) {
        String deviceId = meituanOcpsRequest.getEncryptionDeviceId();
        if (StringUtils.isBlank((String)deviceId)) {
            log.warn("[meituan ocps] deviceId required.");
            throw new NullPointerException("encryptionDeviceId not found");
        }
        KeyValueMap clickLog = (KeyValueMap)this.jedisFetcher.fetch(OcpxKeyGenerator.stringMeituanOcpsCache(deviceId), KeyValueMap.class);
        if (Objects.isNull(clickLog)) {
            log.warn("[meituan ocps]Cannot find click by deviceId - {}", (Object)deviceId);
            throw new NullPointerException("click not found");
        }
        return clickLog;
    }

    public static class MeituanOcpsResponse {
        private String errcode;
        private String errmsg;

        public static MeituanOcpsResponse success() {
            return new MeituanOcpsResponse().setErrcode("0");
        }

        public static MeituanOcpsResponse fail(String errmsg) {
            return new MeituanOcpsResponse().setErrcode(MeituanOcpsController.DEFAULT_EVENT_TYPE).setErrmsg(errmsg);
        }

        public String getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public MeituanOcpsResponse setErrcode(String errcode) {
            this.errcode = errcode;
            return this;
        }

        public MeituanOcpsResponse setErrmsg(String errmsg) {
            this.errmsg = errmsg;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MeituanOcpsResponse)) {
                return false;
            }
            MeituanOcpsResponse other = (MeituanOcpsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$errcode = this.getErrcode();
            String other$errcode = other.getErrcode();
            if (this$errcode == null ? other$errcode != null : !this$errcode.equals(other$errcode)) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            return !(this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MeituanOcpsResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $errcode = this.getErrcode();
            result = result * 59 + ($errcode == null ? 43 : $errcode.hashCode());
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            return result;
        }

        public String toString() {
            return "MeituanOcpsController.MeituanOcpsResponse(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ")";
        }
    }

    public static class MeituanOcpsRequest {
        private String encryptionDeviceId;
        private String quantity;
        private String direct;

        public String getEncryptionDeviceId() {
            return this.encryptionDeviceId;
        }

        public String getQuantity() {
            return this.quantity;
        }

        public String getDirect() {
            return this.direct;
        }

        public MeituanOcpsRequest setEncryptionDeviceId(String encryptionDeviceId) {
            this.encryptionDeviceId = encryptionDeviceId;
            return this;
        }

        public MeituanOcpsRequest setQuantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public MeituanOcpsRequest setDirect(String direct) {
            this.direct = direct;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MeituanOcpsRequest)) {
                return false;
            }
            MeituanOcpsRequest other = (MeituanOcpsRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$encryptionDeviceId = this.getEncryptionDeviceId();
            String other$encryptionDeviceId = other.getEncryptionDeviceId();
            if (this$encryptionDeviceId == null ? other$encryptionDeviceId != null : !this$encryptionDeviceId.equals(other$encryptionDeviceId)) {
                return false;
            }
            String this$quantity = this.getQuantity();
            String other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) {
                return false;
            }
            String this$direct = this.getDirect();
            String other$direct = other.getDirect();
            return !(this$direct == null ? other$direct != null : !this$direct.equals(other$direct));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MeituanOcpsRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $encryptionDeviceId = this.getEncryptionDeviceId();
            result = result * 59 + ($encryptionDeviceId == null ? 43 : $encryptionDeviceId.hashCode());
            String $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : $quantity.hashCode());
            String $direct = this.getDirect();
            result = result * 59 + ($direct == null ? 43 : $direct.hashCode());
            return result;
        }

        public String toString() {
            return "MeituanOcpsController.MeituanOcpsRequest(encryptionDeviceId=" + this.getEncryptionDeviceId() + ", quantity=" + this.getQuantity() + ", direct=" + this.getDirect() + ")";
        }
    }
}

