/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.controller;

import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.model.overseas.OverseasAdvertMediaConfig;
import com.bxm.adscounter.model.overseas.OverseasClickCache;
import com.bxm.adscounter.model.overseas.OverseasRequest;
import com.bxm.adscounter.ocpx.common.OcpxProperties;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.id.random.RandomIdGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cashcat"})
public class OverseasController {
    private static final Logger log = LoggerFactory.getLogger(OverseasController.class);
    private final JedisFetcher jedisFetcher;
    private final JedisUpdater jedisUpdater;
    private final OcpxProperties properties;
    private final OpenLogClient openLogClient;
    private final IdGenerator idGenerator;
    private static final Integer CACHE_EXPIRE_TIME_IN_SECOND = 604800;

    public OverseasController(JedisFetcher jedisFetcher, JedisUpdater jedisUpdater, OcpxProperties properties, OpenLogClient openLogClient) {
        this.jedisFetcher = jedisFetcher;
        this.jedisUpdater = jedisUpdater;
        this.properties = properties;
        this.openLogClient = openLogClient;
        this.idGenerator = new RandomIdGenerator();
    }

    @GetMapping(value={"/page"})
    public void api(HttpServletResponse response, HttpServletRequest request, OverseasRequest param) {
        try {
            this.check(param);
        }
        catch (IllegalArgumentException e) {
            log.error("check occur: {}", (Object)e.getMessage());
            response.setStatus(400);
            return;
        }
        OverseasAdvertMediaConfig config = (OverseasAdvertMediaConfig)this.jedisFetcher.hfetch(RedisKeyGenerator.hashOverseasConfigKey(), param.getConf_id(), OverseasAdvertMediaConfig.class);
        if (Objects.isNull(config)) {
            log.warn("cannot found config by 'conf_id' !");
            response.setStatus(400);
            return;
        }
        String cashcatClickId = this.idGenerator.next();
        this.saveClick(param, request, config, cashcatClickId);
        this.sendOpenLog(param, config, cashcatClickId);
        String trackingLink = config.getTrackingLink();
        try {
            if (StringUtils.isNotBlank((String)trackingLink)) {
                trackingLink = trackingLink.replace("__CLICK_ID__", cashcatClickId).replace("__SITE_ID__", Optional.ofNullable(param.getSite_id()).orElse("NULL")).replace("__GAID__", Optional.ofNullable(param.getGaid()).orElse("NULL"));
                response.sendRedirect(trackingLink);
            }
        }
        catch (IOException e) {
            log.error("redirect occur ex. " + trackingLink, (Throwable)e);
        }
    }

    private void saveClick(OverseasRequest param, HttpServletRequest request, OverseasAdvertMediaConfig config, String cashcatClickId) {
        OverseasClickCache cacheObject = this.toClickCache(param, request, config);
        this.jedisUpdater.update(RedisKeyGenerator.hashOverseasClickIdKey((String)cashcatClickId), (Object)cacheObject, CACHE_EXPIRE_TIME_IN_SECOND.intValue());
    }

    public void sendOpenLog(OverseasRequest request, OverseasAdvertMediaConfig config, String cashcatClickId) {
        KeyValueMap map = new KeyValueMap();
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.OverseasClick.original());
        map.put("site_id", config.getMediaChannel());
        map.put("site_name", config.getMedia());
        map.put("campaign_id", request.getCampaign_id());
        map.put("campaign_name", request.getCampaign_name());
        map.put("offer_id", (Object)config.getAdvertId());
        map.put("click_id", request.getClick_id());
        map.put("time", (Object)System.currentTimeMillis());
        map.put("conf_id", (Object)config.getId());
        map.put("sub_id", request.getSub_id());
        map.put("gaid", request.getGaid());
        map.put("ccid", cashcatClickId);
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
        this.openLogClient.asyncRequest(openLogRequestUri);
        if (log.isDebugEnabled()) {
            log.debug("overseas click dot : {}", (Object)openLogRequestUri);
        }
    }

    private void check(OverseasRequest param) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)param.getClick_id()), (Object)"'click_id' cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)param.getConf_id()), (Object)"'conf_id' cannot be blank");
    }

    private OverseasClickCache toClickCache(OverseasRequest param, HttpServletRequest request, OverseasAdvertMediaConfig config) {
        return OverseasClickCache.builder().clickId(param.getClick_id()).media(config.getMedia()).mediaChannel(config.getMediaChannel()).gaid(param.getGaid()).sourceType(config.getSourceType()).targetType(config.getTargetType()).sourceTargetMapping(config.getSourceTargetMapping()).referer(OverseasController.makeUrl(request)).confId(param.getConf_id()).campaignId(param.getCampaign_id()).campaignName(param.getCampaign_name()).subId(param.getSub_id()).offerId(Objects.toString(config.getAdvertId())).build();
    }

    public static String makeUrl(HttpServletRequest request) {
        return request.getRequestURL().toString() + "?" + request.getQueryString();
    }
}

