/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.baidu;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.baiduocpx.BaiduOcpxRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BaiduConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(BaiduConversionFeedback.class);
    public static final String A_KEY = "akey";
    private final BaiduOcpxRtbIntegration rtbIntegration;

    public BaiduConversionFeedback(BaiduOcpxRtbIntegration rtbIntegration) {
        this.rtbIntegration = rtbIntegration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String akey = (String)feedbackLog.getFirst((Object)"ext_params");
        feedbackLog.put(A_KEY, akey);
        try {
            this.rtbIntegration.doFeedback(FeedbackRequest.builder().keyValueMap(feedbackLog).eventType(targetType).clickId(clickId).build(), 2);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        String akey = (String)clickLog.getFirst((Object)A_KEY);
        if (StringUtils.isBlank((String)akey) && StringUtils.isBlank((String)(akey = (String)clickLog.getFirst((Object)"baidukey")))) {
            log.warn("baidu ocpx akey is null");
        }
        return akey;
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.BAIDU;
    }
}

