/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.cloudmusic;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.cloudmusic.CloudMusicRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CloudMusicFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(CloudMusicFeedback.class);
    private static final String SOURCE = "source_music";
    private static final String APP_KEY = "appkey";
    private static final String APP_SECRET = "appsecret";
    private final CloudMusicRtbIntegration rtbIntegration;

    public CloudMusicFeedback(CloudMusicRtbIntegration rtbIntegration) {
        this.rtbIntegration = rtbIntegration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        byte[] base64;
        JSONObject extParamsJsonObject = new JSONObject();
        String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
        if (StringUtils.isNotBlank((String)extParams) && Objects.isNull(extParamsJsonObject = JSONObject.parseObject((String)StringHelper.convert((byte[])(base64 = Base64.decodeBase64((String)extParams)))))) {
            log.warn("[cloudMusic] extParams is null!");
        }
        feedbackLog.add((Object)SOURCE, (Object)extParamsJsonObject.getString(SOURCE));
        feedbackLog.add((Object)APP_KEY, (Object)extParamsJsonObject.getString(APP_KEY));
        feedbackLog.add((Object)APP_SECRET, (Object)extParamsJsonObject.getString(APP_SECRET));
        try {
            this.rtbIntegration.doFeedback(FeedbackRequest.builder().keyValueMap(feedbackLog).eventType(targetType).clickId(clickId).build(), 2);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.CLOUDMUSIC;
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap<String, Object> ext = new HashMap<String, Object>();
        ext.put(SOURCE, clickLog.getFirst((Object)SOURCE));
        ext.put(APP_KEY, clickLog.getFirst((Object)APP_KEY));
        ext.put(APP_SECRET, clickLog.getFirst((Object)APP_SECRET));
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes(ext));
    }

    @Override
    public void update(KeyValueMap clickLog) {
        if (this.isBlank((String)clickLog.getFirst((Object)"idfa_md5"))) {
            clickLog.remove((Object)"idfa_md5");
        }
        if (this.isBlank((String)clickLog.getFirst((Object)"oaid"))) {
            clickLog.remove((Object)"oaid");
        }
        if (this.isBlank((String)clickLog.getFirst((Object)"imei"))) {
            clickLog.remove((Object)"imei");
        }
        if (this.isBlank((String)clickLog.getFirst((Object)"idfa"))) {
            clickLog.remove((Object)"idfa");
        }
        if (!this.isBlank((String)clickLog.getFirst((Object)"android_id"))) {
            clickLog.put("androidid", (String)clickLog.getFirst((Object)"android_id"));
        }
        if (this.isBlank((String)clickLog.getFirst((Object)"imei_md5"))) {
            clickLog.remove((Object)"imei_md5");
        }
        if (this.isBlank((String)clickLog.getFirst((Object)"oaid_md5"))) {
            clickLog.remove((Object)"oaid_md5");
        }
    }

    private boolean isBlank(String device) {
        return StringUtils.isBlank((String)device) || "null".equals(device);
    }
}

