/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.guangdiantong;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class GuangdiantongConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(GuangdiantongConversionFeedback.class);
    public static final String DEVICE_OS_TYPE = "device_os_type";
    private final HttpClient httpClient = HttpClientUtils.createHttpClient(50, 100, 1000, 500, 1000);
    private static final String START_APP = "START_APP";

    @Override
    public void update(KeyValueMap clickLog) {
        String clickId;
        String os = (String)clickLog.getFirst((Object)DEVICE_OS_TYPE);
        if (StringUtils.isNotBlank((String)os)) {
            clickLog.put("x_os", os);
        }
        if (StringUtils.isNotBlank((String)(clickId = (String)clickLog.getFirst((Object)"click_id")))) {
            clickId = UrlHelper.urlEncode((String)Base64.encodeBase64String((byte[])clickId.getBytes()));
            clickLog.put("click_id", clickId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        byte[] base64;
        String feedbackUrlBase64 = UrlHelper.urlDecode((String)clickId);
        String feedbackUrl = new String(Base64.decodeBase64((String)feedbackUrlBase64));
        if (StringUtils.isBlank((String)feedbackUrl)) {
            return;
        }
        String url = UriComponentsBuilder.fromUriString((String)UrlHelper.urlDecode((String)feedbackUrl)).build().toString();
        JSONObject extParamsJsonObject = new JSONObject();
        String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
        if (StringUtils.isNotBlank((String)extParams) && Objects.isNull(extParamsJsonObject = JSONObject.parseObject((String)StringHelper.convert((byte[])(base64 = Base64.decodeBase64((String)extParams)))))) {
            log.warn("[guangdiantong] extParams is null!");
        }
        String oaid = extParamsJsonObject.getString("oaid");
        String imeiMd5 = extParamsJsonObject.getString("imei_md5");
        String idfaMd5 = extParamsJsonObject.getString("idfa_md5");
        String androidIdMd5 = extParamsJsonObject.getString("androidid_md5");
        String os = extParamsJsonObject.getString(DEVICE_OS_TYPE);
        boolean isIos = Objects.equals(os, "ios");
        UserId.UserIdBuilder userIdBuilder = UserId.builder();
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            userIdBuilder.hash_imei(imeiMd5);
        } else if (StringUtils.isNotBlank((String)idfaMd5) && isIos) {
            userIdBuilder.hash_idfa(idfaMd5);
        } else if (StringUtils.isNotBlank((String)oaid)) {
            userIdBuilder.oaid(oaid);
        } else if (StringUtils.isNotBlank((String)androidIdMd5)) {
            userIdBuilder.hash_android_id(androidIdMd5);
        }
        HashMap<String, Object> actionParam = null;
        if (START_APP.equals(targetType)) {
            actionParam = new HashMap<String, Object>(){
                {
                    this.put("length_of_stay", 1);
                }
            };
        }
        ArrayList actions = Lists.newArrayList((Object[])new Action[]{Action.builder().action_type(targetType).user_id(userIdBuilder.build()).action_param((Map<String, Object>)actionParam).build()});
        GdtReqeuset gdtReqeuset = GdtReqeuset.builder().actions(actions).build();
        String entity = JsonHelper.convert((Object)gdtReqeuset);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        try {
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)post);
            log.info("[guangdiantong] ocpx conversion success - url: {} - requestJson: {} - response: {} ", new Object[]{url, entity, EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8)});
        }
        catch (IOException e) {
            log.error("execute: ", (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.GUANGDIANTONG;
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap ext = Maps.newHashMap();
        ext.put("oaid", clickLog.getFirst((Object)"oaid"));
        ext.put("imei", clickLog.getFirst((Object)"imei"));
        ext.put("imei_md5", clickLog.getFirst((Object)"imei_md5"));
        ext.put("idfa", clickLog.getFirst((Object)"idfa"));
        ext.put("idfa_md5", clickLog.getFirst((Object)"idfa_md5"));
        ext.put("androidid", clickLog.getFirst((Object)"androidid"));
        ext.put("androidid_md5", clickLog.getFirst((Object)"androidid_md5"));
        ext.put(DEVICE_OS_TYPE, clickLog.getFirst((Object)DEVICE_OS_TYPE));
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes((Object)ext));
    }

    public static void main(String[] args) {
        GuangdiantongConversionFeedback guangdiantongConversionFeedback = new GuangdiantongConversionFeedback();
        KeyValueMap keyValueMap = new KeyValueMap();
        String clickId = "aHR0cCUzQSUyRiUyRnRyYWNraW5nLmUucXEuY29tJTJGY29udiUzRmNiJTNEQkVBYzE5LXFkZ05GUnlwa1JjN0ZhWGw5VW91MV9zeGlaYzY1RzFxdjdTSSUyNTNEJTI2Y29udl9pZCUzRDg0OTAzNjY%3D";
        String targetType = "ACTIVATE_APP";
        keyValueMap.put("imei_md5", "f9efca36a3c30e1cf28170d86ecbf5e9");
        String extParams = guangdiantongConversionFeedback.createExtParams(keyValueMap);
        keyValueMap.set((Object)"ext_params", (Object)extParams);
        guangdiantongConversionFeedback.feedback(keyValueMap, clickId, targetType);
    }

    private static class UserId {
        private String hash_imei;
        private String hash_idfa;
        private String hash_android_id;
        private String hash_mac;
        private String oaid;

        public static UserIdBuilder builder() {
            return new UserIdBuilder();
        }

        public String getHash_imei() {
            return this.hash_imei;
        }

        public String getHash_idfa() {
            return this.hash_idfa;
        }

        public String getHash_android_id() {
            return this.hash_android_id;
        }

        public String getHash_mac() {
            return this.hash_mac;
        }

        public String getOaid() {
            return this.oaid;
        }

        public void setHash_imei(String hash_imei) {
            this.hash_imei = hash_imei;
        }

        public void setHash_idfa(String hash_idfa) {
            this.hash_idfa = hash_idfa;
        }

        public void setHash_android_id(String hash_android_id) {
            this.hash_android_id = hash_android_id;
        }

        public void setHash_mac(String hash_mac) {
            this.hash_mac = hash_mac;
        }

        public void setOaid(String oaid) {
            this.oaid = oaid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserId)) {
                return false;
            }
            UserId other = (UserId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hash_imei = this.getHash_imei();
            String other$hash_imei = other.getHash_imei();
            if (this$hash_imei == null ? other$hash_imei != null : !this$hash_imei.equals(other$hash_imei)) {
                return false;
            }
            String this$hash_idfa = this.getHash_idfa();
            String other$hash_idfa = other.getHash_idfa();
            if (this$hash_idfa == null ? other$hash_idfa != null : !this$hash_idfa.equals(other$hash_idfa)) {
                return false;
            }
            String this$hash_android_id = this.getHash_android_id();
            String other$hash_android_id = other.getHash_android_id();
            if (this$hash_android_id == null ? other$hash_android_id != null : !this$hash_android_id.equals(other$hash_android_id)) {
                return false;
            }
            String this$hash_mac = this.getHash_mac();
            String other$hash_mac = other.getHash_mac();
            if (this$hash_mac == null ? other$hash_mac != null : !this$hash_mac.equals(other$hash_mac)) {
                return false;
            }
            String this$oaid = this.getOaid();
            String other$oaid = other.getOaid();
            return !(this$oaid == null ? other$oaid != null : !this$oaid.equals(other$oaid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash_imei = this.getHash_imei();
            result = result * 59 + ($hash_imei == null ? 43 : $hash_imei.hashCode());
            String $hash_idfa = this.getHash_idfa();
            result = result * 59 + ($hash_idfa == null ? 43 : $hash_idfa.hashCode());
            String $hash_android_id = this.getHash_android_id();
            result = result * 59 + ($hash_android_id == null ? 43 : $hash_android_id.hashCode());
            String $hash_mac = this.getHash_mac();
            result = result * 59 + ($hash_mac == null ? 43 : $hash_mac.hashCode());
            String $oaid = this.getOaid();
            result = result * 59 + ($oaid == null ? 43 : $oaid.hashCode());
            return result;
        }

        public String toString() {
            return "GuangdiantongConversionFeedback.UserId(hash_imei=" + this.getHash_imei() + ", hash_idfa=" + this.getHash_idfa() + ", hash_android_id=" + this.getHash_android_id() + ", hash_mac=" + this.getHash_mac() + ", oaid=" + this.getOaid() + ")";
        }

        public UserId(String hash_imei, String hash_idfa, String hash_android_id, String hash_mac, String oaid) {
            this.hash_imei = hash_imei;
            this.hash_idfa = hash_idfa;
            this.hash_android_id = hash_android_id;
            this.hash_mac = hash_mac;
            this.oaid = oaid;
        }

        public static class UserIdBuilder {
            private String hash_imei;
            private String hash_idfa;
            private String hash_android_id;
            private String hash_mac;
            private String oaid;

            UserIdBuilder() {
            }

            public UserIdBuilder hash_imei(String hash_imei) {
                this.hash_imei = hash_imei;
                return this;
            }

            public UserIdBuilder hash_idfa(String hash_idfa) {
                this.hash_idfa = hash_idfa;
                return this;
            }

            public UserIdBuilder hash_android_id(String hash_android_id) {
                this.hash_android_id = hash_android_id;
                return this;
            }

            public UserIdBuilder hash_mac(String hash_mac) {
                this.hash_mac = hash_mac;
                return this;
            }

            public UserIdBuilder oaid(String oaid) {
                this.oaid = oaid;
                return this;
            }

            public UserId build() {
                return new UserId(this.hash_imei, this.hash_idfa, this.hash_android_id, this.hash_mac, this.oaid);
            }

            public String toString() {
                return "GuangdiantongConversionFeedback.UserId.UserIdBuilder(hash_imei=" + this.hash_imei + ", hash_idfa=" + this.hash_idfa + ", hash_android_id=" + this.hash_android_id + ", hash_mac=" + this.hash_mac + ", oaid=" + this.oaid + ")";
            }
        }
    }

    private static class Action {
        private String action_type;
        private Map<String, Object> action_param;
        private UserId user_id;

        public static ActionBuilder builder() {
            return new ActionBuilder();
        }

        public String getAction_type() {
            return this.action_type;
        }

        public Map<String, Object> getAction_param() {
            return this.action_param;
        }

        public UserId getUser_id() {
            return this.user_id;
        }

        public void setAction_type(String action_type) {
            this.action_type = action_type;
        }

        public void setAction_param(Map<String, Object> action_param) {
            this.action_param = action_param;
        }

        public void setUser_id(UserId user_id) {
            this.user_id = user_id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$action_type = this.getAction_type();
            String other$action_type = other.getAction_type();
            if (this$action_type == null ? other$action_type != null : !this$action_type.equals(other$action_type)) {
                return false;
            }
            Map<String, Object> this$action_param = this.getAction_param();
            Map<String, Object> other$action_param = other.getAction_param();
            if (this$action_param == null ? other$action_param != null : !((Object)this$action_param).equals(other$action_param)) {
                return false;
            }
            UserId this$user_id = this.getUser_id();
            UserId other$user_id = other.getUser_id();
            return !(this$user_id == null ? other$user_id != null : !((Object)this$user_id).equals(other$user_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $action_type = this.getAction_type();
            result = result * 59 + ($action_type == null ? 43 : $action_type.hashCode());
            Map<String, Object> $action_param = this.getAction_param();
            result = result * 59 + ($action_param == null ? 43 : ((Object)$action_param).hashCode());
            UserId $user_id = this.getUser_id();
            result = result * 59 + ($user_id == null ? 43 : ((Object)$user_id).hashCode());
            return result;
        }

        public String toString() {
            return "GuangdiantongConversionFeedback.Action(action_type=" + this.getAction_type() + ", action_param=" + this.getAction_param() + ", user_id=" + this.getUser_id() + ")";
        }

        public Action(String action_type, Map<String, Object> action_param, UserId user_id) {
            this.action_type = action_type;
            this.action_param = action_param;
            this.user_id = user_id;
        }

        public static class ActionBuilder {
            private String action_type;
            private Map<String, Object> action_param;
            private UserId user_id;

            ActionBuilder() {
            }

            public ActionBuilder action_type(String action_type) {
                this.action_type = action_type;
                return this;
            }

            public ActionBuilder action_param(Map<String, Object> action_param) {
                this.action_param = action_param;
                return this;
            }

            public ActionBuilder user_id(UserId user_id) {
                this.user_id = user_id;
                return this;
            }

            public Action build() {
                return new Action(this.action_type, this.action_param, this.user_id);
            }

            public String toString() {
                return "GuangdiantongConversionFeedback.Action.ActionBuilder(action_type=" + this.action_type + ", action_param=" + this.action_param + ", user_id=" + this.user_id + ")";
            }
        }
    }

    private static class GdtReqeuset {
        private List<Action> actions;

        public static GdtReqeusetBuilder builder() {
            return new GdtReqeusetBuilder();
        }

        public List<Action> getActions() {
            return this.actions;
        }

        public void setActions(List<Action> actions) {
            this.actions = actions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GdtReqeuset)) {
                return false;
            }
            GdtReqeuset other = (GdtReqeuset)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Action> this$actions = this.getActions();
            List<Action> other$actions = other.getActions();
            return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GdtReqeuset;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Action> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            return result;
        }

        public String toString() {
            return "GuangdiantongConversionFeedback.GdtReqeuset(actions=" + this.getActions() + ")";
        }

        public GdtReqeuset(List<Action> actions) {
            this.actions = actions;
        }

        public static class GdtReqeusetBuilder {
            private List<Action> actions;

            GdtReqeusetBuilder() {
            }

            public GdtReqeusetBuilder actions(List<Action> actions) {
                this.actions = actions;
                return this;
            }

            public GdtReqeuset build() {
                return new GdtReqeuset(this.actions);
            }

            public String toString() {
                return "GuangdiantongConversionFeedback.GdtReqeuset.GdtReqeusetBuilder(actions=" + this.actions + ")";
            }
        }
    }
}

