/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.huawei;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.huawei.HuaweiOcpxRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HuaweiConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(HuaweiConversionFeedback.class);
    private static final String CONTENT_ID = "content_id";
    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String OAID = "oaid";
    private static final String CALLBACK = "callback";
    private static final String TOKEN = "token";
    private final HuaweiOcpxRtbIntegration huaweiOcpxRtbIntegration;

    public HuaweiConversionFeedback(HuaweiOcpxRtbIntegration huaweiOcpxRtbIntegration) {
        this.huaweiOcpxRtbIntegration = huaweiOcpxRtbIntegration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
        if (StringUtils.isBlank((String)extParams)) {
            log.warn("Huawei Cannot found extParams");
            return;
        }
        byte[] base64 = Base64.decodeBase64((String)extParams);
        JSONObject extParamsJsonObject = JSONObject.parseObject((String)StringHelper.convert((byte[])base64));
        String contentId = extParamsJsonObject.getString(CONTENT_ID);
        String campaignId = extParamsJsonObject.getString(CAMPAIGN_ID);
        String oaid = extParamsJsonObject.getString(OAID);
        String callback = extParamsJsonObject.getString(CALLBACK);
        String token = extParamsJsonObject.getString(TOKEN);
        feedbackLog.put(CONTENT_ID, contentId);
        feedbackLog.put(CAMPAIGN_ID, campaignId);
        feedbackLog.put(OAID, oaid);
        feedbackLog.put(CALLBACK, callback);
        feedbackLog.put(TOKEN, token);
        FeedbackRequest request = FeedbackRequest.builder().keyValueMap(feedbackLog).clickId(clickId).eventType(targetType).build();
        try {
            this.huaweiOcpxRtbIntegration.doFeedback(request);
        }
        catch (RtbIntegrationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.HUAWEI;
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap ext = Maps.newHashMap();
        ext.put(CONTENT_ID, clickLog.getFirst((Object)CONTENT_ID));
        ext.put(CAMPAIGN_ID, clickLog.getFirst((Object)CAMPAIGN_ID));
        ext.put(OAID, clickLog.getFirst((Object)OAID));
        ext.put(CALLBACK, clickLog.getFirst((Object)CALLBACK));
        ext.put(TOKEN, clickLog.getFirst((Object)TOKEN));
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes((Object)ext));
    }
}

