/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.kuaishou;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.UrlHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KuaishouConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(KuaishouConversionFeedback.class);
    private final KuaishouRtbIntegration kuaishouRtbIntegration;

    public KuaishouConversionFeedback(KuaishouRtbIntegration kuaishouRtbIntegration) {
        this.kuaishouRtbIntegration = kuaishouRtbIntegration;
    }

    @Override
    public void update(KeyValueMap clickLog) {
        String clickId = (String)clickLog.getFirst((Object)"click_id");
        if (StringUtils.isNotBlank((String)clickId)) {
            clickLog.put("click_id", Base64.encodeBase64URLSafeString((byte[])StringHelper.convert((String)clickId)));
        }
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        try {
            byte[] base64 = Base64.decodeBase64((String)clickId);
            String callbackUrl = StringHelper.convert((byte[])base64);
            String callback = UrlHelper.getFirstValueOfParamName((String)callbackUrl, (String)"callback");
            this.kuaishouRtbIntegration.doFeedback(FeedbackRequest.builder().keyValueMap(feedbackLog).eventType(targetType).clickId(callback).build(), 2);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.KUAISHOU;
    }
}

